<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_product_batch".
 *
 * @property int $it_easy_id
 * @property string $it_easy_batch
 * @property int|null $created_by
 * @property string|null $created_time
 */
class ItEasyProductBatch extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_product_batch';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_batch'], 'required'],
            [['created_by'], 'integer'],
            [['created_time'], 'safe'],
            [['it_easy_batch'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_batch' => 'Batch',
            'created_by' => 'Created By',
            'created_time' => 'Created Time',
        ];
    }
}
