<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyProductBatch;

/**
 * ItEasyProductBatchSearch represents the model behind the search form of `backend\models\ItEasyProductBatch`.
 */
class ItEasyProductBatchSearch extends ItEasyProductBatch
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'created_by'], 'integer'],
            [['it_easy_batch', 'created_time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyProductBatch::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'created_by' => $this->created_by,
            'created_time' => $this->created_time,
        ]);

        $query->andFilterWhere(['like', 'it_easy_batch', $this->it_easy_batch]);

        return $dataProvider;
    }
}
