<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_product_material".
 *
 * @property int $it_easy_id
 * @property string $it_easy_material_name
 * @property string $it_easy_material_form
 * @property string $it_easy_material_weight_type
 * @property string $it_easy_material_quantity
 * @property string $it_easy_material_type
 * @property string $it_easy_status
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property int|null $created_by
 * @property int|null $updated_by
 */
class ItEasyProductMaterial extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_product_material';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_material_name', 'it_easy_material_form', 'it_easy_material_weight_type', 'it_easy_material_quantity', 'it_easy_material_type', 'it_easy_status'], 'required'],
            [['created_time', 'updated_time'], 'safe'],
            [['created_by', 'updated_by','it_easy_material_quantity'], 'integer'],
            [['it_easy_material_name'], 'string', 'max' => 200],
            [['it_easy_material_form'], 'string', 'max' => 100],
            [['it_easy_material_weight_type', 'it_easy_material_quantity'], 'string', 'max' => 20],
            [['it_easy_material_type'], 'string', 'max' => 60],
            [['it_easy_status'], 'string', 'max' => 15],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_material_name' => 'Material Name',
            'it_easy_material_form' => 'Material Form',
            'it_easy_material_weight_type' => 'Material Weight Type',
            'it_easy_material_quantity' => 'Material Quantity',
            'it_easy_material_type' => 'Material Type',
            'it_easy_status' => 'Status',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }
}
