<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyProduct;

/**
 * ItEasyProductSearch represents the model behind the search form of `backend\models\ItEasyProduct`.
 */
class ItEasyProductSearch extends ItEasyProduct
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_product_id', 'it_easy_product_category_id', 'it_easy_product_one_bottle_quantity', 'it_easy_product_quantity', 'it_easy_tax_price', 'it_easy_price_without_tax', 'it_easy_product_tax', 'it_easy_product_feature_status', 'it_easy_product_brand_id', 'it_easy_product_approved_by', 'created_by', 'update_by'], 'integer'],
            [['it_easy_product_name', 'it_easy_product_sku', 'it_easy_product_description', 'it_easy_product_type', 'it_easy_weight_type', 'it_easy_product_stock_id', 'it_easy_discount_start_date', 'it_easy_discount_end_date', 'it_easy_product_image', 'it_easy_product_status', 'created_time', 'updated_time'], 'safe'],
            [['it_easy_product_price', 'it_easy_product_mrp', 'it_easy_product_discount', 'it_easy_product_width', 'it_easy_product_height', 'it_easy_product_length'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyProduct::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_product_id' => $this->it_easy_product_id,
            'it_easy_product_category_id' => $this->it_easy_product_category_id,
            'it_easy_product_one_bottle_quantity' => $this->it_easy_product_one_bottle_quantity,
            'it_easy_product_quantity' => $this->it_easy_product_quantity,
            'it_easy_product_price' => $this->it_easy_product_price,
            'it_easy_product_mrp' => $this->it_easy_product_mrp,
            'it_easy_tax_price' => $this->it_easy_tax_price,
            'it_easy_product_discount' => $this->it_easy_product_discount,
            'it_easy_discount_start_date' => $this->it_easy_discount_start_date,
            'it_easy_discount_end_date' => $this->it_easy_discount_end_date,
            'it_easy_price_without_tax' => $this->it_easy_price_without_tax,
            'it_easy_product_tax' => $this->it_easy_product_tax,
            'it_easy_product_width' => $this->it_easy_product_width,
            'it_easy_product_height' => $this->it_easy_product_height,
            'it_easy_product_length' => $this->it_easy_product_length,
            'it_easy_product_feature_status' => $this->it_easy_product_feature_status,
            'it_easy_product_brand_id' => $this->it_easy_product_brand_id,
            'it_easy_product_approved_by' => $this->it_easy_product_approved_by,
            'created_time' => $this->created_time,
            'updated_time' => $this->updated_time,
            'created_by' => $this->created_by,
            'update_by' => $this->update_by,
        ]);

        $query->andFilterWhere(['like', 'it_easy_product_name', $this->it_easy_product_name])
            ->andFilterWhere(['like', 'it_easy_product_sku', $this->it_easy_product_sku])
            ->andFilterWhere(['like', 'it_easy_product_description', $this->it_easy_product_description])
            ->andFilterWhere(['like', 'it_easy_product_type', $this->it_easy_product_type])
            ->andFilterWhere(['like', 'it_easy_weight_type', $this->it_easy_weight_type])
            ->andFilterWhere(['like', 'it_easy_product_stock_id', $this->it_easy_product_stock_id])
            ->andFilterWhere(['like', 'it_easy_product_image', $this->it_easy_product_image])
            ->andFilterWhere(['=', 'it_easy_product_status', $this->it_easy_product_status]);

        return $dataProvider;
    }
}
