<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_product_unit_material".
 *
 * @property int $id
 * @property int $it_easy_product_id
 * @property int $it_easy_variation_id
 * @property int $it_easy_material_id
 * @property string $it_easy_quantity
 * @property string $it_easy_weight_type
 * @property int|null $created_by
 * @property string|null $created_time
 */
class ItEasyProductUnitMaterial extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_product_unit_material';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_product_id', 'it_easy_variation_id', 'it_easy_material_id', 'it_easy_quantity', 'it_easy_weight_type'], 'required'],
            [['it_easy_product_id', 'it_easy_variation_id', 'it_easy_material_id', 'created_by'], 'integer'],
            [['created_time'], 'safe'],
            [['it_easy_quantity'], 'string', 'max' => 30],
            [['it_easy_weight_type'], 'string', 'max' => 55],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'it_easy_product_id' => 'It Easy Product ID',
            'it_easy_variation_id' => 'It Easy Variation ID',
            'it_easy_material_id' => 'It Easy Material ID',
            'it_easy_quantity' => 'It Easy Quantity',
            'it_easy_weight_type' => 'It Easy Weight Type',
            'created_by' => 'Created By',
            'created_time' => 'Created Time',
        ];
    }
}
