<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_product_variation".
 *
 * @property int $it_easy_id
 * @property int $it_easy_product_id
 * @property int $it_easy_variation_id
 * @property string $it_easy_varation_quantity
 * @property float $it_easy_varation_price
 * @property float $it_easy_varation_mrp
 * @property float|null $it_easy_tax_price
 * @property float|null $it_easy_price_without_tax
 * @property int|null $it_easy_product_tax
 * @property string $it_easy_status
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property int|null $created_by
 * @property int|null $updated_by
 */
class ItEasyProductVariation extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_product_variation';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_product_id', 'it_easy_variation_id', 'it_easy_varation_quantity', 'it_easy_varation_price', 'it_easy_varation_mrp', 'it_easy_status'], 'required'],
            [['it_easy_product_id', 'it_easy_variation_id', 'it_easy_product_tax', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_varation_price', 'it_easy_varation_mrp', 'it_easy_tax_price', 'it_easy_price_without_tax'], 'number'],
            [['created_time', 'updated_time'], 'safe'],
            [['it_easy_varation_quantity', 'it_easy_status', 'it_easy_product_weight'], 'string', 'max' => 30],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_product_id' => 'Product Name',
            'it_easy_variation_id' => 'Variation Name',
            'it_easy_varation_quantity' => 'Variation Quantity',
            'it_easy_varation_price' => 'Variation Price',
            'it_easy_varation_mrp' => 'Varation Mrp',
            'it_easy_tax_price' => 'Tax Price',
            'it_easy_price_without_tax' => 'Price Without Tax',
            'it_easy_product_tax' => 'Product Tax',
            'it_easy_status' => 'Status',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }
  
  public function getVariationData(){
        $connection = \Yii::$app->db;
        $sql = "select * from it_easy_product_variation_attribute where it_easy_status = 'Active'";
        $command = $connection->createCommand($sql);
        $data = $command->queryAll();
        return $data;
    }
}
