<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_raise_request".
 *
 * @property int $it_easy_id
 * @property int $it_easy_user_id
 * @property string $it_easy_raise_comment
 * @property string|null $it_easy_solve_comment
 * @property int|null $it_easy_solved_by
 * @property string $it_easy_status
 * @property int $it_easy_satisfied
 * @property string|null $it_easy_created_time
 * @property string|null $it_easy_updated_time
 * @property int|null $it_easy_created_by
 * @property int|null $it_easy_updated_by
 */
class ItEasyRaiseRequest extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_raise_request';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_user_id', 'it_easy_raise_comment'], 'required'],
            [['it_easy_user_id', 'it_easy_solved_by', 'it_easy_satisfied', 'it_easy_created_by', 'it_easy_updated_by'], 'integer'],
            [['it_easy_raise_comment', 'it_easy_status'], 'string'],
            [['it_easy_created_time', 'it_easy_updated_time'], 'safe'],
            [['it_easy_solve_comment'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'It Easy ID',
            'it_easy_user_id' => 'User Name',
            'it_easy_raise_comment' => 'Raise Comment',
            'it_easy_solve_comment' => 'Solve Comment',
            'it_easy_solved_by' => 'Solved By',
            'it_easy_status' => 'Status',
            'it_easy_satisfied' => 'Satisfied',
            'it_easy_created_time' => 'Created Time',
            'it_easy_updated_time' => 'Updated Time',
            'it_easy_created_by' => 'It Easy Created By',
            'it_easy_updated_by' => 'It Easy Updated By',
        ];
    }
}
