<?php

namespace backend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyRaiseRequest;

/**
 * ItEasyRaiseRequestSearch represents the model behind the search form of `backend\models\ItEasyRaiseRequest`.
 */
class ItEasyRaiseRequestSearch extends ItEasyRaiseRequest
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'it_easy_user_id', 'it_easy_solved_by', 'it_easy_satisfied', 'it_easy_created_by', 'it_easy_updated_by'], 'integer'],
            [['it_easy_raise_comment', 'it_easy_solve_comment', 'it_easy_status', 'it_easy_created_time', 'it_easy_updated_time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyRaiseRequest::find();

        if(Yii::$app->user->identity->it_easy_dept_id != '8' && Yii::$app->user->identity->it_easy_dept_id != '1'){
            
                $query->andWhere([ 'it_easy_user_id' => Yii::$app->user->identity->id]);
            
        }

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'sort'=> ['defaultOrder' => ['it_easy_updated_time' => SORT_DESC]],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'it_easy_user_id' => $this->it_easy_user_id,
            'it_easy_solved_by' => $this->it_easy_solved_by,
            'it_easy_satisfied' => $this->it_easy_satisfied,
            'it_easy_created_time' => $this->it_easy_created_time,
            'it_easy_updated_time' => $this->it_easy_updated_time,
            'it_easy_created_by' => $this->it_easy_created_by,
            'it_easy_updated_by' => $this->it_easy_updated_by,
        ]);

        $query->andFilterWhere(['like', 'it_easy_raise_comment', $this->it_easy_raise_comment])
            ->andFilterWhere(['like', 'it_easy_solve_comment', $this->it_easy_solve_comment])
            ->andFilterWhere(['like', 'it_easy_status', $this->it_easy_status]);

        return $dataProvider;
    }
}
