<?php

namespace backend\models;

use Yii;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyOrder;

use yii\base\Model;



class ItEasyRetention extends ItEasyOrder
{
    public $it_easy_awb_number;
    public $it_easy_courier_name;

    public function rules()
    {
        return [
            [['it_easy_order_id', 'it_easy_store_id', 'it_easy_customer_id', 'it_easy_shipping_state_id', 'it_easy_billing_gst_status', 'it_easy_billing_state_id', 'it_easy_department_id',  'it_easy_ndr_tl', 'it_easy_ndr_agent', 'it_easy_read_status', 'it_easy_address_verify_by', 'it_easy_marketer_id'], 'integer'],
            [['it_easy_financial_year', 'it_easy_order_number', 'it_easy_invoice_number', 'it_easy_store_name', 'it_easy_other_order_id', 'it_easy_firstname', 'it_easy_lastname', 'it_easy_mobile_number', 'it_easy_alternate_number', 'it_easy_email', 'it_easy_address_1', 'it_easy_address_2', 'it_easy_city', 'it_easy_state', 'it_easy_pincode', 'it_easy_fax', 'it_easy_country', 'it_easy_shipping_firstname', 'it_easy_shipping_lastname', 'it_easy_shipping_mobile_number', 'it_easy_shipping_alternate_number', 'it_easy_shipping_email', 'it_easy_shipping_address_1', 'it_easy_shipping_address_2', 'it_easy_shipping_city', 'it_easy_shipping_state', 'it_easy_shipping_pincode', 'it_easy_shipping_country', 'it_easy_billing_company_name', 'it_easy_billing_gst', 'it_easy_billing_firstname', 'it_easy_billing_lastname', 'it_easy_billing_mobile', 'it_easy_billing_alternate_number', 'it_easy_billing_email', 'it_easy_billing_address_1', 'it_easy_billing_address_2', 'it_easy_billing_city', 'it_easy_billing_state', 'it_easy_billing_pincode', 'it_easy_billing_country', 'it_easy_payment_method', 'it_easy_payment_code', 'it_easy_shipping_method', 'it_easy_shipping_code', 'it_easy_order_serviceable', 'it_easy_comment', 'it_easy_first_status', 'it_easy_marketer_publisher', 'it_easy_marketer_click_id', 'it_easy_client_ip', 'it_easy_server_ip', 'it_easy_device', 'it_easy_browser', 'it_easy_previous_url', 'it_easy_page_url', 'it_easy_created_time', 'it_easy_updated_time', 'it_easy_assign_time', 'it_easy_placed_time', 'it_easy_delivered_time', 'date_type_filter', 'date_from_date', 'date_to_date', 'assign_type', 'it_easy_state_id', 'it_easy_assigned_by', 'it_easy_assigned_to', 'it_easy_disease_name','it_easy_course_duration'], 'safe'],
            [['it_easy_total_price', 'it_easy_gst_price'], 'number'],
        ];
    }
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }
    public function search($params)
    {
        // echo"<pre>";print_r($params);die;
        $query = ItEasyRetention::find();

        if (!empty($params) && $params['ItEasyRetention']['it_easy_course_duration'] == '1 week') {
            $filter_date = date('Y-m-d', strtotime('-1 week'));
            $course_duration = '1 week';
        } else if (!empty($params) && $params['ItEasyRetention']['it_easy_course_duration'] == '15 days') {
            $filter_date = date('Y-m-d', strtotime('-15 days'));

            $course_duration = '15 days';
        } else if (!empty($params) && $params['ItEasyRetention']['it_easy_course_duration'] == '1 month') {

            $filter_date = date('Y-m-d', strtotime('-1 month'));
            $course_duration = '1 month';
        } else if (!empty($params) && $params['ItEasyRetention']['it_easy_course_duration'] == '45 days') {

            $filter_date = date('Y-m-d', strtotime('-45 days'));
            $course_duration = '45 days';
        }else if (!empty($params) && $params['ItEasyRetention']['it_easy_course_duration'] == '2 months') {

            $filter_date = date('Y-m-d', strtotime('-2 months'));

            $course_duration = '2 months';
        } else if (!empty($params) && $params['ItEasyRetention']['it_easy_course_duration'] == '3 months') {

            $filter_date = date('Y-m-d', strtotime('-3 months'));

            $course_duration = '3 months';
        } else if (!empty($params) && $params['ItEasyRetention']['it_easy_course_duration'] == '4 months') {

            $filter_date = date('Y-m-d', strtotime('-4 months'));

            $course_duration = '4 months';
        } else if (!empty($params) && $params['ItEasyRetention']['it_easy_course_duration'] == '5 months') {

            $filter_date = date('Y-m-d', strtotime('-5 months'));

            $course_duration = '5 months';
        } else if (!empty($params) && $params['ItEasyRetention']['it_easy_course_duration'] == '6 months') {

            $filter_date = date('Y-m-d', strtotime('-6 months'));

            $course_duration = '6 months';
        } else {

            $filter_date = date('Y-m-d', strtotime('-1 week'));
            $course_duration = '1 week';
        }


        // $query->andWhere(['date(it_easy_delivered_time)' < $filter_date])->andWhere(['it_easy_course_duration' => $course_duration]);
        $query->andWhere(['<', 'date(it_easy_placed_time)', $filter_date])->andWhere(['it_easy_course_duration' => $course_duration]);

    // echo"<pre>";print_r($query->createCommand()->getRawSql());die;

        // $query->andWhere(['date(it_easy_delivered_time)' => $filter_date]);
        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
            'pageSize' => 100,
        ],
        ]);

        $this->load($params);
        if (!$this->validate()) {
            return $dataProvider;
        }

        $query->andFilterWhere([
            'it_easy_assigned_to' => $this->it_easy_assigned_to,
            'it_easy_assigned_by' => $this->it_easy_assigned_by,
            'it_easy_state_id' => $this->it_easy_state_id,
            'it_easy_first_status' => $this->it_easy_first_status,
            'it_easy_delivered_time' => $this->it_easy_delivered_time,
        ]);
        if(Yii::$app->user->identity->it_easy_dept_id == '4'){
            if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
                $query->andWhere(['it_easy_assigned_to' => Yii::$app->user->identity->id]);
            }
        }
        // $query->andFilterWhere(['like','it_easy_disease_name', $this->it_easy_disease_name]);
       
   
          
        //   echo"<pre>";print_r($query->createCommand()->getRawSql());die;
        return $dataProvider;
     
    }
}
