<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_shipping_api".
 *
 * @property int $it_easy_ship_id
 * @property string $it_easy_name
 * @property string $it_easy_userName
 * @property string $it_easy_passWord
 * @property string|null $it_easy_auth_key
 * @property float|null $it_easy_zone_a
 * @property float|null $it_easy_zone_b
 * @property float|null $it_easy_zone_c
 * @property float|null $it_easy_zone_d
 * @property float|null $it_easy_zone_e
 * @property float|null $it_easy_additional_zone_a
 * @property float|null $it_easy_additional_zone_b
 * @property float|null $it_easy_additional_zone_c
 * @property float|null $it_easy_additional_zone_d
 * @property float|null $it_easy_additional_zone_e
 * @property float|null $it_easy_fixed_cod_charges
 * @property string|null $it_easy_percentage_cod_charges in Percentage
 * @property float|null $it_easy_freight_charges
 * @property string $status
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property string|null $created_time
 * @property string|null $updated_time
 */
class ItEasyShippingApi extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_shipping_api';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_name', 'it_easy_userName', 'it_easy_passWord'], 'required'],
            [['it_easy_zone_a', 'it_easy_zone_b', 'it_easy_zone_c', 'it_easy_zone_d', 'it_easy_zone_e', 'it_easy_additional_zone_a', 'it_easy_additional_zone_b', 'it_easy_additional_zone_c', 'it_easy_additional_zone_d', 'it_easy_additional_zone_e', 'it_easy_fixed_cod_charges', 'it_easy_freight_charges'], 'number'],
            [['status'], 'string'],
            [['created_by', 'updated_by'], 'integer'],
            [['created_time', 'updated_time'], 'safe'],
            [['it_easy_name', 'it_easy_userName', 'it_easy_passWord'], 'string', 'max' => 60],
            [['it_easy_auth_key'], 'string', 'max' => 100],
            [['it_easy_percentage_cod_charges'], 'string', 'max' => 10],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_ship_id' => 'Ship ID',
            'it_easy_name' => 'Name',
            'it_easy_userName' => 'Username',
            'it_easy_passWord' => 'Pass Word',
            'it_easy_auth_key' => 'Auth Key',
            'it_easy_zone_a' => 'Zone A',
            'it_easy_zone_b' => 'Zone B',
            'it_easy_zone_c' => 'Zone C',
            'it_easy_zone_d' => 'Zone D',
            'it_easy_zone_e' => 'Zone E',
            'it_easy_additional_zone_a' => 'Additional Zone A',
            'it_easy_additional_zone_b' => 'Additional Zone B',
            'it_easy_additional_zone_c' => 'Additional Zone C',
            'it_easy_additional_zone_d' => 'Additional Zone D',
            'it_easy_additional_zone_e' => 'Additional Zone E',
            'it_easy_fixed_cod_charges' => 'Fixed Cod Charges',
            'it_easy_percentage_cod_charges' => 'Percentage Cod Charges',
            'it_easy_freight_charges' => 'Freight Charges',
            'status' => 'Status',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
        ];
    }
}
