<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyShippingApi;

/**
 * ItEasyShippingApiSearch represents the model behind the search form of `backend\models\ItEasyShippingApi`.
 */
class ItEasyShippingApiSearch extends ItEasyShippingApi
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_ship_id', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_name', 'it_easy_userName', 'it_easy_passWord', 'it_easy_auth_key', 'it_easy_percentage_cod_charges', 'status', 'created_time', 'updated_time'], 'safe'],
            [['it_easy_zone_a', 'it_easy_zone_b', 'it_easy_zone_c', 'it_easy_zone_d', 'it_easy_zone_e', 'it_easy_additional_zone_a', 'it_easy_additional_zone_b', 'it_easy_additional_zone_c', 'it_easy_additional_zone_d', 'it_easy_additional_zone_e', 'it_easy_fixed_cod_charges', 'it_easy_freight_charges'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyShippingApi::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_ship_id' => $this->it_easy_ship_id,
            'it_easy_zone_a' => $this->it_easy_zone_a,
            'it_easy_zone_b' => $this->it_easy_zone_b,
            'it_easy_zone_c' => $this->it_easy_zone_c,
            'it_easy_zone_d' => $this->it_easy_zone_d,
            'it_easy_zone_e' => $this->it_easy_zone_e,
            'it_easy_additional_zone_a' => $this->it_easy_additional_zone_a,
            'it_easy_additional_zone_b' => $this->it_easy_additional_zone_b,
            'it_easy_additional_zone_c' => $this->it_easy_additional_zone_c,
            'it_easy_additional_zone_d' => $this->it_easy_additional_zone_d,
            'it_easy_additional_zone_e' => $this->it_easy_additional_zone_e,
            'it_easy_fixed_cod_charges' => $this->it_easy_fixed_cod_charges,
            'it_easy_freight_charges' => $this->it_easy_freight_charges,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'created_time' => $this->created_time,
            'updated_time' => $this->updated_time,
        ]);

        $query->andFilterWhere(['like', 'it_easy_name', $this->it_easy_name])
            ->andFilterWhere(['like', 'it_easy_userName', $this->it_easy_userName])
            ->andFilterWhere(['like', 'it_easy_passWord', $this->it_easy_passWord])
            ->andFilterWhere(['like', 'it_easy_auth_key', $this->it_easy_auth_key])
            ->andFilterWhere(['like', 'it_easy_percentage_cod_charges', $this->it_easy_percentage_cod_charges])
            ->andFilterWhere(['=', 'status', $this->status]);

        return $dataProvider;
    }
}
