<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_shipping_payment_method".
 *
 * @property int $it_easy_id
 * @property string $it_easy_method_type
 * @property string $it_easy_method_name
 * @property string $it_easy_method_code
 * @property string $it_easy_method_value_type
 * @property string $it_easy_add_value_type
 * @property float $it_easy_method_value
 * @property string $it_easy_status
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property string|null $created_time
 * @property string|null $updated_time
 */
class ItEasyShippingPaymentMethod extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_shipping_payment_method';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_method_type', 'it_easy_method_name', 'it_easy_method_code', 'it_easy_method_value_type', 'it_easy_add_value_type', 'it_easy_status'], 'required'],
            [['it_easy_method_type', 'it_easy_method_value_type', 'it_easy_add_value_type', 'it_easy_status'], 'string'],
            [['it_easy_method_value'], 'number'],
            [['created_by', 'updated_by'], 'integer'],
            [['created_time', 'updated_time'], 'safe'],
            [['it_easy_method_name'], 'string', 'max' => 80],
            [['it_easy_method_code'], 'string', 'max' => 40],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_method_type' => 'Shipping Payment Method Type',
            'it_easy_method_name' => 'Shipping Payment Method Name',
            'it_easy_method_code' => 'Shipping Payment Method Code',
            'it_easy_method_value_type' => 'Shipping Payment Method Value Type',
            'it_easy_add_value_type' => 'Shipping Payment Add  Type',
            'it_easy_method_value' => 'Shipping Payment Method Value',
            'it_easy_status' => 'Shipping Payment Status',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
        ];
    }


    public static function getShippingbyMethodcode($code){
        $data = ItEasyShippingPaymentMethod::findOne(['it_easy_method_code' => $code]);
        return $data;
    }
}
