<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyShippingPaymentMethod;

/**
 * ItEasyShippingPaymentMethodSearch represents the model behind the search form of `backend\models\ItEasyShippingPaymentMethod`.
 */
class ItEasyShippingPaymentMethodSearch extends ItEasyShippingPaymentMethod
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_method_type', 'it_easy_method_name', 'it_easy_method_code', 'it_easy_method_value_type', 'it_easy_add_value_type', 'it_easy_status', 'created_time', 'updated_time'], 'safe'],
            [['it_easy_method_value'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyShippingPaymentMethod::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'it_easy_method_value' => $this->it_easy_method_value,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'created_time' => $this->created_time,
            'updated_time' => $this->updated_time,
        ]);

        $query->andFilterWhere(['like', 'it_easy_method_type', $this->it_easy_method_type])
            ->andFilterWhere(['like', 'it_easy_method_name', $this->it_easy_method_name])
            ->andFilterWhere(['like', 'it_easy_method_code', $this->it_easy_method_code])
            ->andFilterWhere(['like', 'it_easy_method_value_type', $this->it_easy_method_value_type])
            ->andFilterWhere(['like', 'it_easy_add_value_type', $this->it_easy_add_value_type])
            ->andFilterWhere(['like', 'it_easy_status', $this->it_easy_status]);

        return $dataProvider;
    }
}
