<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_state".
 *
 * @property int $it_easy_id
 * @property string $it_easy_country_name
 * @property string $it_easy_state_name
 * @property string|null $it_easy_state_name2
 * @property string|null $it_easy_state_name3
 * @property string|null $it_easy_state_name4
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property string $it_easy_status
 */
class ItEasyState extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_state';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_country_name', 'it_easy_state_name'], 'required'],
            [['created_by', 'updated_by'], 'integer'],
            [['created_time', 'updated_time'], 'safe'],
            [['it_easy_country_name'], 'string', 'max' => 150],
            [['it_easy_state_name', 'it_easy_state_name2', 'it_easy_state_name3', 'it_easy_state_name4'], 'string', 'max' => 50],
            [['it_easy_status'], 'string', 'max' => 20],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_country_name' => 'Country Name',
            'it_easy_state_name' => 'State Name',
            'it_easy_state_name2' => 'State Name2',
            'it_easy_state_name3' => 'State Name3',
            'it_easy_state_name4' => 'State Name4',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'it_easy_status' => 'Status',
        ];
    }

    public static function getStatedatabyId($Id){
            $get_state = ItEasyState::findOne(['it_easy_id' => $Id]);
            return $get_state;
    }

    public static function getStateallData(){
            $get_state = ItEasyState::find()->select(['it_easy_id', 'it_easy_state_name'])->all();
            return $get_state;
    }
  
  	public static function getStatedatabyStateName($name){
            $get_state = ItEasyState::find()->where(['or', ['it_easy_state_name' => $name], ['it_easy_state_name2' => $name], ['it_easy_state_name3' => $name], ['it_easy_state_name4' => $name] ])->one();
            return $get_state;
    }
  	
}
