<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyState;

/**
 * ItEasyStateSearch represents the model behind the search form of `backend\models\ItEasyState`.
 */
class ItEasyStateSearch extends ItEasyState
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_country_name', 'it_easy_state_name', 'it_easy_state_name2', 'it_easy_state_name3', 'it_easy_state_name4', 'created_time', 'updated_time', 'it_easy_status'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyState::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'created_time' => $this->created_time,
            'updated_time' => $this->updated_time,
        ]);

        $query->andFilterWhere(['like', 'it_easy_country_name', $this->it_easy_country_name])
            ->andFilterWhere(['like', 'it_easy_state_name', $this->it_easy_state_name])
            ->orFilterWhere(['like', 'it_easy_state_name2', $this->it_easy_state_name])
            ->orFilterWhere(['like', 'it_easy_state_name3', $this->it_easy_state_name])
            ->orFilterWhere(['like', 'it_easy_state_name4', $this->it_easy_state_name])
            ->andFilterWhere(['like', 'it_easy_status', $this->it_easy_status]);

        return $dataProvider;
    }
}
