<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_store".
 *
 * @property int $it_easy_id
 * @property string $it_easy_store_name
 * @property string|null $it_easy_store_url
 * @property string $it_easy_store_mobile
 * @property string|null $it_easy_store_email
 * @property string $it_easy_address_1
 * @property string|null $it_easy_address_2
 * @property string $it_easy_city
 * @property string $it_easy_state
 * @property string $it_easy_pincode
 * @property string|null $it_easy_gst_number
 * @property string|null $it_easy_registered_name
 * @property int $is_buyer_product
 * @property int $is_manufacturer
 * @property string $it_easy_status
 * @property string $it_easy_store_logo
 * @property string $created_time
 * @property string $updated_time
 * @property int $created_by
 * @property int $updated_by
 */
class ItEasyStore extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_store';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_store_name', 'it_easy_store_mobile', 'it_easy_address_1', 'it_easy_city', 'it_easy_state', 'it_easy_pincode', 'it_easy_status','created_time', 'updated_time','it_easy_registered_name','created_by', 'updated_by'], 'required'],
            [['is_buyer_product', 'is_manufacturer', 'created_by', 'updated_by'], 'integer'],
            [['created_time', 'updated_time'], 'safe'],
            [['it_easy_store_name', 'it_easy_store_url'], 'string', 'max' => 100],
            [['it_easy_store_mobile', 'it_easy_gst_number', 'it_easy_status'], 'string', 'max' => 20],
            [['it_easy_store_email', 'it_easy_registered_name'], 'string', 'max' => 80],
            [['it_easy_address_1', 'it_easy_address_2'], 'string', 'max' => 150],
            [['it_easy_city', 'it_easy_state'], 'string', 'max' => 60],
            [['it_easy_pincode'], 'string', 'max' => 10],
            [['it_easy_store_logo'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_store_name' => ' Name',
            'it_easy_store_url' => ' Url',
            'it_easy_store_mobile' => ' Mobile',
            'it_easy_store_email' => ' Email',
            'it_easy_address_1' => ' Address 1',
            'it_easy_address_2' => ' Address 2',
            'it_easy_city' => ' City',
            'it_easy_state' => ' State',
            'it_easy_pincode' => ' Pincode',
            'it_easy_gst_number' => ' Gst Number',
            'it_easy_registered_name' => ' Registered Name',
            'is_buyer_product' => 'Is Buyer Product',
            'is_manufacturer' => 'Is Manufacturer',
            'it_easy_status' => ' Status',
            'it_easy_store_logo' => ' Logo',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }
  
  	public static function getStorename(){
        $store_data = ItEasyStore::findOne(['it_easy_id' => '1']);
        return $store_data;
    }
  	
}
