<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyStore;

/**
 * ItEasyStoreSearch represents the model behind the search form of `backend\models\ItEasyStore`.
 */
class ItEasyStoreSearch extends ItEasyStore
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'is_buyer_product', 'is_manufacturer', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_store_name', 'it_easy_store_url', 'it_easy_store_mobile', 'it_easy_store_email', 'it_easy_address_1', 'it_easy_address_2', 'it_easy_city', 'it_easy_state', 'it_easy_pincode', 'it_easy_gst_number', 'it_easy_registered_name', 'it_easy_status', 'it_easy_store_logo', 'created_time', 'updated_time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyStore::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'is_buyer_product' => $this->is_buyer_product,
            'is_manufacturer' => $this->is_manufacturer,
            'created_time' => $this->created_time,
            'updated_time' => $this->updated_time,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'it_easy_store_name', $this->it_easy_store_name])
            ->andFilterWhere(['like', 'it_easy_store_url', $this->it_easy_store_url])
            ->andFilterWhere(['like', 'it_easy_store_mobile', $this->it_easy_store_mobile])
            ->andFilterWhere(['like', 'it_easy_store_email', $this->it_easy_store_email])
            ->andFilterWhere(['like', 'it_easy_address_1', $this->it_easy_address_1])
            ->andFilterWhere(['like', 'it_easy_address_2', $this->it_easy_address_2])
            ->andFilterWhere(['like', 'it_easy_city', $this->it_easy_city])
            ->andFilterWhere(['like', 'it_easy_state', $this->it_easy_state])
            ->andFilterWhere(['like', 'it_easy_pincode', $this->it_easy_pincode])
            ->andFilterWhere(['like', 'it_easy_gst_number', $this->it_easy_gst_number])
            ->andFilterWhere(['like', 'it_easy_registered_name', $this->it_easy_registered_name])
            ->andFilterWhere(['=', 'it_easy_status', $this->it_easy_status])
            ->andFilterWhere(['like', 'it_easy_store_logo', $this->it_easy_store_logo]);

        return $dataProvider;
    }
}
