<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_tax".
 *
 * @property int $it_easy_tax_id
 * @property string $it_easy_tax_name
 * @property int $it_easy_tax_percentage
 * @property string $it_easy_tax_type
 * @property string $it_easy_tax_status
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property int|null $created_by
 * @property int|null $updated_by
 */
class ItEasyTax extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_tax';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_tax_name', 'it_easy_tax_percentage', 'it_easy_tax_type', 'it_easy_tax_status'], 'required'],
            [['it_easy_tax_percentage', 'created_by', 'updated_by'], 'integer'],
            [['created_time', 'updated_time'], 'safe'],
            [['it_easy_tax_name'], 'string', 'max' => 40],
            [['it_easy_tax_type'], 'string', 'max' => 50],
            [['it_easy_tax_status'], 'string', 'max' => 15],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_tax_id' => 'Tax ID',
            'it_easy_tax_name' => 'Tax Name',
            'it_easy_tax_percentage' => 'Tax Percentage',
            'it_easy_tax_type' => 'Tax Type',
            'it_easy_tax_status' => 'Tax Status',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }
}
