<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyTax;

/**
 * ItEasyTaxSearch represents the model behind the search form of `backend\models\ItEasyTax`.
 */
class ItEasyTaxSearch extends ItEasyTax
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_tax_id', 'it_easy_tax_percentage', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_tax_name', 'it_easy_tax_type', 'it_easy_tax_status', 'created_time', 'updated_time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyTax::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_tax_id' => $this->it_easy_tax_id,
            'it_easy_tax_percentage' => $this->it_easy_tax_percentage,
            'created_time' => $this->created_time,
            'updated_time' => $this->updated_time,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'it_easy_tax_name', $this->it_easy_tax_name])
            ->andFilterWhere(['like', 'it_easy_tax_type', $this->it_easy_tax_type])
            ->andFilterWhere(['like', 'it_easy_tax_status', $this->it_easy_tax_status]);

        return $dataProvider;
    }
}
