<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_team".
 *
 * @property int $it_easy_id
 * @property string $it_easy_team_name
 * @property int $it_easy_parent_user
 * @property string $it_easy_child_user
 * @property string $status
 * @property int|null $created_by
 * @property string|null $created_time
 * @property int|null $updated_by
 * @property string|null $updated_time
 */
class ItEasyTeam extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_team';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_team_name', 'it_easy_parent_user', 'it_easy_child_user', 'status'], 'required'],
            [['it_easy_parent_user', 'created_by', 'updated_by'], 'integer'],
            [['status'], 'string'],
            [['created_time', 'updated_time'], 'safe'],
            [['it_easy_team_name'], 'string', 'max' => 20],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => ' ID',
            'it_easy_team_name' => ' Team Name',
            'it_easy_parent_user' => ' Parent User',
            'it_easy_child_user' => ' Child User',
            'status' => 'Status',
            'created_by' => 'Created By',
            'created_time' => 'Created Time',
            'updated_by' => 'Updated By',
            'updated_time' => 'Updated Time',
        ];
    }
}
