<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_user".
 *
 * @property int $id
 * @property int $it_easy_dept_id
 * @property int $it_easy_type_id
 * @property string $it_easy_firstname
 * @property string $it_easy_lastname
 * @property string $it_easy_username
 * @property string $auth_key
 * @property string $it_easy_password_hash
 * @property string|null $password_reset_token
 * @property string $email
 * @property int $is_manufacturer
 * @property int $is_product_buyer
 * @property string $status
 * @property string|null $it_easy_permissions
 * @property string|null $last_login_ip
 * @property int|null $login_status
 * @property string|null $login_browser
 * @property string|null $login_device
 * @property int|null $created_at
 * @property int|null $updated_at
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property string|null $verification_token
 */
class ItEasyUser extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_user';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_dept_id', 'it_easy_type_id', 'it_easy_firstname', 'it_easy_lastname', 'it_easy_username', 'auth_key', 'email', 'status'], 'required'],
            [['it_easy_password_hash'],  'required', 'on' => 'create'],
            [['it_easy_dept_id', 'it_easy_type_id', 'is_manufacturer', 'is_product_buyer', 'login_status', 'created_at', 'updated_at'], 'integer'],
            [['it_easy_permissions'], 'string'],
            [['created_time', 'updated_time', 'it_easy_platform'], 'safe'],
            [['it_easy_firstname', 'it_easy_lastname'], 'string', 'max' => 100],
            [['it_easy_username', 'it_easy_password_hash', 'password_reset_token', 'email', 'verification_token'], 'string', 'max' => 255],
            [['auth_key'], 'string', 'max' => 32],
            [['status'], 'string', 'max' => 20],
            [['last_login_ip'], 'string', 'max' => 120],
            [['login_browser', 'login_device'], 'string', 'max' => 150],
            [['it_easy_username'], 'unique'],
            [['email'], 'unique'],
            [['password_reset_token'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'it_easy_dept_id' => 'Department Name',
            'it_easy_type_id' => 'User Type',
            'it_easy_firstname' => 'User Firstname',
            'it_easy_lastname' => 'User Lastname',
            'it_easy_username' => 'Username',
            'auth_key' => 'Auth Key',
            'it_easy_password_hash' => 'It Easy Password Hash',
            'password_reset_token' => 'Password Reset Token',
            'email' => 'Email',
            'is_manufacturer' => 'Is Manufacturer',
            'is_product_buyer' => 'Is Product Buyer',
            'status' => 'Status',
            'it_easy_permissions' => 'It Easy Permissions',
            'last_login_ip' => 'Last Login Ip',
            'login_status' => 'Login Status',
            'login_browser' => 'Login Browser',
            'login_device' => 'Login Device',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'verification_token' => 'Verification Token',
        ];
    }

    
  
}
