<?php

namespace backend\models;


use Yii;

/**
 * This is the model class for table "it_easy_user_connected_status".
 *
 * @property int $it_easy_id
 * @property int $it_easy_department_id
 * @property int $it_easy_user_type_id
 * @property string|null $it_easy_department_name
 * @property string|null $it_easy_user_type_name
 * @property string $it_easy_status_id
 * @property string $it_easy_disposition_id
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property int|null $updated_by
 * @property int|null $created_by
 */
class ItEasyUserConnectedStatus extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_user_connected_status';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_department_id', 'it_easy_user_type_id', 'it_easy_status_id', 'it_easy_disposition_id'], 'required'],
            [['it_easy_department_id', 'it_easy_user_type_id', 'updated_by', 'created_by'], 'safe'],
            [['it_easy_status_id', 'it_easy_disposition_id'], 'safe'],
            [['created_time', 'updated_time'], 'safe'],
            [['it_easy_department_name' , 'it_easy_user_type_name'],'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'It Easy ID',
            'it_easy_department_id' => 'It Easy Department ID',
            'it_easy_user_type_id' => 'It Easy User Type ID',
            'it_easy_department_name' => 'It Easy Department Name',
            'it_easy_user_type_name' => 'It Easy User Type Name',
            'it_easy_status_id' => 'It Easy Status ID',
            'it_easy_disposition_id' => 'It Easy Disposition ID',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'updated_by' => 'Updated By',
            'created_by' => 'Created By',
        ];
    }
}
