<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyUserConnectedStatus;

/**
 * ItEasyUserConnectedStatusSearch represents the model behind the search form of `backend\models\ItEasyUserConnectedStatus`.
 */
class ItEasyUserConnectedStatusSearch extends ItEasyUserConnectedStatus
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'it_easy_department_id', 'it_easy_user_type_id', 'updated_by', 'created_by'], 'integer'],
            [['it_easy_department_name', 'it_easy_user_type_name', 'it_easy_status_id', 'it_easy_disposition_id', 'created_time', 'updated_time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyUserConnectedStatus::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'it_easy_department_id' => $this->it_easy_department_id,
            'it_easy_user_type_id' => $this->it_easy_user_type_id,
            'created_time' => $this->created_time,
            'updated_time' => $this->updated_time,
            'updated_by' => $this->updated_by,
            'created_by' => $this->created_by,
        ]);

        $query->andFilterWhere(['like', 'it_easy_department_name', $this->it_easy_department_name])
            ->andFilterWhere(['like', 'it_easy_user_type_name', $this->it_easy_user_type_name])
            ->andFilterWhere(['like', 'it_easy_status_id', $this->it_easy_status_id])
            ->andFilterWhere(['like', 'it_easy_disposition_id', $this->it_easy_disposition_id]);

        return $dataProvider;
    }
}
