<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_user_permission_group".
 *
 * @property int $id
 * @property string $name
 * @property string $permission_menu
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property int|null $created_by
 * @property int|null $updated_by
 */
class ItEasyUserPermissionGroup extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_user_permission_group';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'permission_menu'], 'required'],
           
            [['created_time', 'updated_time','it_easy_id','permission_menu'], 'safe'],
            [['created_by', 'updated_by'], 'integer'],
            [['name'], 'string', 'max' => 80],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'permission_menu' => 'Permission Menu',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }
  
  	public static function getLogisticPermission(){
      	$permission_check = ItEasyUserPermissionGroup::find()->where(['name' => 'Logistic Admin'])->asArray()->one();
        return $array_permission_array = explode(",",$permission_check['permission_menu']);
    }
  
  	public static function getQualityPermission(){
      	$permission_check = ItEasyUserPermissionGroup::find()->where(['name' => 'Quality Admin'])->asArray()->one();
        return $array_permission_array = explode(",",$permission_check['permission_menu']);
    }
  
  	public static function getProcurementPermission(){
      	$permission_check = ItEasyUserPermissionGroup::find()->where(['name' => 'Product & Procurement Admin'])->asArray()->one();
        return $array_permission_array = explode(",",$permission_check['permission_menu']);
    }
  
  	public static function getSalesPermission(){
      	if(Yii::$app->user->identity->it_easy_type_id == '1'){
            $permission_check = ItEasyUserPermissionGroup::find()->where(['name' => 'Sales Admin'])->asArray()->one();
            $sales_permission = explode(",",$permission_check['permission_menu']);
        }else if(Yii::$app->user->identity->it_easy_type_id == '2'){
            $salemanager_permission_check = ItEasyUserPermissionGroup::find()->where(['name' => 'Sales Manager'])->asArray()->one();
            $sales_permission = explode(",",$salemanager_permission_check['permission_menu']);
        }else if(Yii::$app->user->identity->it_easy_type_id == '3'){
            $saletlpermission_check = ItEasyUserPermissionGroup::find()->where(['name' => 'Sales TL'])->asArray()->one();
            $sales_permission = explode(",",$saletlpermission_check['permission_menu']);
        }else if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){
            $saleagentpermission_check = ItEasyUserPermissionGroup::find()->where(['name' => 'Sales Agent'])->asArray()->one();
            $sales_permission = explode(",",$saleagentpermission_check['permission_menu']);
        }
      	return $sales_permission;
    }
  
  	public static function getNDRPermission(){
      	if(Yii::$app->user->identity->it_easy_type_id == '1'){
            $permission_check = ItEasyUserPermissionGroup::find()->where(['name' => 'NDR Admin'])->asArray()->one();
            $sales_permission = explode(",",$permission_check['permission_menu']);
        }else if(Yii::$app->user->identity->it_easy_type_id == '2'){
            $salemanager_permission_check = ItEasyUserPermissionGroup::find()->where(['name' => 'NDR Manager'])->asArray()->one();
            $sales_permission = explode(",",$salemanager_permission_check['permission_menu']);
        }else if(Yii::$app->user->identity->it_easy_type_id == '3'){
            $saletlpermission_check = ItEasyUserPermissionGroup::find()->where(['name' => 'NDR TL'])->asArray()->one();
            $sales_permission = explode(",",$saletlpermission_check['permission_menu']);
        }else if(Yii::$app->user->identity->it_easy_type_id == '4' || Yii::$app->user->identity->it_easy_type_id == '5'){  
            $saleagentpermission_check = ItEasyUserPermissionGroup::find()->where(['name' => 'NDR Agent'])->asArray()->one();
            $sales_permission = explode(",",$saleagentpermission_check['permission_menu']);
        }
      	return $sales_permission;
    }
}
