<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyUser;

/**
 * ItEasyUserSearch represents the model behind the search form of `backend\models\ItEasyUser`.
 */
class ItEasyUserSearch extends ItEasyUser
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'it_easy_dept_id', 'it_easy_type_id', 'is_manufacturer', 'is_product_buyer', 'login_status', 'created_at', 'updated_at'], 'integer'],
            [['it_easy_firstname', 'it_easy_lastname', 'it_easy_username', 'auth_key', 'it_easy_password_hash', 'password_reset_token', 'email', 'status', 'it_easy_permissions', 'last_login_ip', 'login_browser', 'login_device', 'created_time', 'updated_time', 'verification_token', 'it_easy_platform'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyUser::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
            'pageSize' => 100,
        ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'it_easy_dept_id' => $this->it_easy_dept_id,
            'it_easy_type_id' => $this->it_easy_type_id,
            'is_manufacturer' => $this->is_manufacturer,
            'is_product_buyer' => $this->is_product_buyer,
            'login_status' => $this->login_status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'created_time' => $this->created_time,
            'updated_time' => $this->updated_time,
            'status' => $this->status
        ]);

        $query->andFilterWhere(['like', 'it_easy_firstname', $this->it_easy_firstname])
            ->andFilterWhere(['like', 'it_easy_lastname', $this->it_easy_lastname])
            ->andFilterWhere(['like', 'it_easy_username', $this->it_easy_username])
            ->andFilterWhere(['like', 'it_easy_platform', $this->it_easy_platform])
            ->andFilterWhere(['like', 'auth_key', $this->auth_key])
            ->andFilterWhere(['like', 'it_easy_password_hash', $this->it_easy_password_hash])
            ->andFilterWhere(['like', 'password_reset_token', $this->password_reset_token])
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'it_easy_permissions', $this->it_easy_permissions])
            ->andFilterWhere(['like', 'last_login_ip', $this->last_login_ip])
            ->andFilterWhere(['like', 'login_browser', $this->login_browser])
            ->andFilterWhere(['like', 'login_device', $this->login_device])
            ->andFilterWhere(['like', 'verification_token', $this->verification_token]);

        return $dataProvider;
    }

    public function livesearch($params)
    {
        $query = ItEasyUser::find()->where(['login_status'=>1]);

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'it_easy_dept_id' => $this->it_easy_dept_id,
            'it_easy_type_id' => $this->it_easy_type_id,
            'is_manufacturer' => $this->is_manufacturer,
            'is_product_buyer' => $this->is_product_buyer,
            'login_status' => $this->login_status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'created_time' => $this->created_time,
            'updated_time' => $this->updated_time,
        ]);

        $query->andFilterWhere(['like', 'it_easy_firstname', $this->it_easy_firstname])
            ->andFilterWhere(['like', 'it_easy_lastname', $this->it_easy_lastname])
            ->andFilterWhere(['like', 'it_easy_username', $this->it_easy_username])
            ->andFilterWhere(['like', 'auth_key', $this->auth_key])
            ->andFilterWhere(['like', 'it_easy_password_hash', $this->it_easy_password_hash])
            ->andFilterWhere(['like', 'password_reset_token', $this->password_reset_token])
            ->andFilterWhere(['like', 'email', $this->email])
            ->andFilterWhere(['like', 'status', $this->status])
            ->andFilterWhere(['like', 'it_easy_permissions', $this->it_easy_permissions])
            ->andFilterWhere(['like', 'last_login_ip', $this->last_login_ip])
            ->andFilterWhere(['like', 'login_browser', $this->login_browser])
            ->andFilterWhere(['like', 'login_device', $this->login_device])
            ->andFilterWhere(['like', 'verification_token', $this->verification_token]);

        return $dataProvider;
    }
}
