<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_vendor".
 *
 * @property int $it_easy_id
 * @property string|null $it_easy_vendor_code
 * @property string $it_easy_vendor_name
 * @property string|null $it_easy_vendor_mobile
 * @property string|null $it_easy_vendor_email
 * @property string $it_easy_vendor_address
 * @property string|null $it_easy_vendor_city
 * @property string|null $it_easy_vendor_state
 * @property string|null $it_easy_vendor_pincode
 * @property string|null $it_easy_vendor_type
 * @property string $it_easy_status
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property int|null $created_by
 * @property int|null $updated_by
 */
class ItEasyVendor extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_vendor';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_vendor_type','it_easy_vendor_name','it_easy_vendor_code','it_easy_vendor_mobile','it_easy_vendor_email','it_easy_vendor_city','it_easy_vendor_state','it_easy_vendor_pincode','it_easy_vendor_address', 'it_easy_status'], 'required'],
            [['created_time', 'updated_time'], 'safe'],
            [['created_by', 'updated_by'], 'integer'],
            [['it_easy_vendor_code', 'it_easy_vendor_name', 'it_easy_vendor_type'], 'string', 'max' => 80],
            [['it_easy_vendor_mobile'], 'string', 'max' => 16],
            [['it_easy_vendor_email'],'email'],
            [['it_easy_vendor_address'], 'string', 'max' => 150],
            [['it_easy_vendor_city', 'it_easy_vendor_state'], 'string', 'max' => 30],
            [['it_easy_vendor_pincode'], 'string', 'max' => 10],
            [['it_easy_status'], 'string', 'max' => 15],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_vendor_code' => 'Vendor Code',
            'it_easy_vendor_name' => 'Vendor Name',
            'it_easy_vendor_mobile' => 'Vendor Mobile',
            'it_easy_vendor_email' => 'Vendor Email',
            'it_easy_vendor_address' => 'Vendor Address',
            'it_easy_vendor_city' => 'Vendor City',
            'it_easy_vendor_state' => 'Vendor State',
            'it_easy_vendor_pincode' => 'Vendor Pincode',
            'it_easy_vendor_type' => 'Vendor Type',
            'it_easy_status' => 'Status',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }
}
