<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyWarehouseHistory;

/**
 * ItEasyWarehouseHistorySearch represents the model behind the search form of `backend\models\ItEasyWarehouseHistory`.
 */
class ItEasyWarehouseHistorySearch extends ItEasyWarehouseHistory
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'it_easy_warehouse_id', 'it_easy_product_id', 'it_easy_variation_id', 'created_time', 'updated_time', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_warehouse_name', 'it_easy_product_name', 'it_easy_product_quantity'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyWarehouseHistory::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'it_easy_warehouse_id' => $this->it_easy_warehouse_id,
            'it_easy_product_id' => $this->it_easy_product_id,
            'it_easy_variation_id' => $this->it_easy_variation_id,
            'created_time' => $this->created_time,
            'updated_time' => $this->updated_time,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'it_easy_warehouse_name', $this->it_easy_warehouse_name])
            ->andFilterWhere(['like', 'it_easy_product_name', $this->it_easy_product_name])
            ->andFilterWhere(['like', 'it_easy_product_quantity', $this->it_easy_product_quantity]);

        return $dataProvider;
    }
}
