<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_warehouse_history".
 *
 * @property int $it_easy_id
 * @property int $it_easy_warehouse_id
 * @property string|null $it_easy_warehouse_name
 * @property int $it_easy_product_id
 * @property string|null $it_easy_product_name
 * @property int $it_easy_variation_id
 * @property string $it_easy_product_quantity
 * @property int|null $created_time
 * @property int|null $updated_time
 * @property int|null $created_by
 * @property int|null $updated_by
 */
class ItEasyWarehouseHistory extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_warehouse_history';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_warehouse_id', 'it_easy_product_id', 'it_easy_variation_id', 'it_easy_product_quantity','it_easy_received_by','it_easy_received_date'], 'required'],
            [['it_easy_warehouse_id', 'it_easy_product_id', 'it_easy_variation_id', 'created_time', 'updated_time', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_warehouse_name'], 'string', 'max' => 150],
            [['it_easy_product_name'], 'string', 'max' => 255],
            [['it_easy_product_quantity'], 'string', 'max' => 30],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_warehouse_id' => 'Warehouse ID',
            'it_easy_warehouse_name' => 'Warehouse Name',
            'it_easy_product_id' => 'Product ID',
            'it_easy_product_name' => 'Product Name',
            'it_easy_variation_id' => 'Variation ID',
            'it_easy_product_quantity' => 'Product Quantity',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }


         public function getVaritionData($productid){
        $connection = \Yii::$app->db;
        $sql = "select it_easy_product_variation_attribute.it_easy_id,it_easy_product_variation_attribute.it_easy_variation_name from it_easy_product_variation LEFT JOIN it_easy_product_variation_attribute ON it_easy_product_variation.it_easy_variation_id = it_easy_product_variation_attribute.it_easy_id where it_easy_product_variation.it_easy_product_id = ".$productid." GROUP BY it_easy_product_variation.it_easy_variation_id";
        $command = $connection->createCommand($sql);
        $data = $command->queryAll();
        $redata = '';
        $redata .= "<option value=''>Select</option>";
        foreach ($data as $key => $value) {
           $redata .= "<option value=".$value['it_easy_id'].">".$value['it_easy_variation_name']."</option>";
        }
        echo $redata;
        
    }
}
