<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_warehouse_product_quantity".
 *
 * @property int $id
 * @property int $warehouse_id
 * @property int $product_id
 * @property int $variation_id
 * @property int $quantity
 * @property string $last_update_time
 */
class ItEasyWarehouseProductQuantity extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_warehouse_product_quantity';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            // [['warehouse_id', 'product_id', 'variation_id', 'quantity', 'last_update_time'], 'required'],
            [['warehouse_id', 'product_id', 'variation_id', 'quantity'], 'integer'],
            [['last_update_time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'warehouse_id' => 'Warehouse ID',
            'product_id' => 'Product ID',
            'variation_id' => 'Variation ID',
            'quantity' => 'Quantity',
            'last_update_time' => 'Last Update Time',
        ];
    }
}
