<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyWarehouse;

/**
 * ItEasyWarehouseSearch represents the model behind the search form of `backend\models\ItEasyWarehouse`.
 */
class ItEasyWarehouseSearch extends ItEasyWarehouse
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_warehouse_id', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_warehouse_code', 'it_easy_warehouse_name', 'it_easy_warehouse_mobile', 'it_easy_warehouse_email', 'it_easy_warehouse_address', 'it_easy_warehouse_city', 'it_easy_warehouse_state', 'it_easy_warehouse_pincode', 'it_easy_warehouse_type', 'it_easy_product_quantity', 'it_easy_status', 'created_time', 'updated_time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyWarehouse::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_warehouse_id' => $this->it_easy_warehouse_id,
            'created_time' => $this->created_time,
            'updated_time' => $this->updated_time,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'it_easy_warehouse_code', $this->it_easy_warehouse_code])
            ->andFilterWhere(['like', 'it_easy_warehouse_name', $this->it_easy_warehouse_name])
            ->andFilterWhere(['like', 'it_easy_warehouse_mobile', $this->it_easy_warehouse_mobile])
            ->andFilterWhere(['like', 'it_easy_warehouse_email', $this->it_easy_warehouse_email])
            ->andFilterWhere(['like', 'it_easy_warehouse_address', $this->it_easy_warehouse_address])
            ->andFilterWhere(['like', 'it_easy_warehouse_city', $this->it_easy_warehouse_city])
            ->andFilterWhere(['like', 'it_easy_warehouse_state', $this->it_easy_warehouse_state])
            ->andFilterWhere(['like', 'it_easy_warehouse_pincode', $this->it_easy_warehouse_pincode])
            ->andFilterWhere(['like', 'it_easy_warehouse_type', $this->it_easy_warehouse_type])
            ->andFilterWhere(['like', 'it_easy_product_quantity', $this->it_easy_product_quantity])
            ->andFilterWhere(['like', 'it_easy_status', $this->it_easy_status]);

        return $dataProvider;
    }
}
