<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_warehouse".
 *
 * @property int $it_easy_warehouse_id
 * @property string|null $it_easy_warehouse_code
 * @property string $it_easy_warehouse_name
 * @property string|null $it_easy_warehouse_mobile
 * @property string|null $it_easy_warehouse_email
 * @property string $it_easy_warehouse_address
 * @property string|null $it_easy_warehouse_city
 * @property string|null $it_easy_warehouse_state
 * @property string|null $it_easy_warehouse_pincode
 * @property string|null $it_easy_warehouse_type
 * @property string $it_easy_product_quantity
 * @property string $it_easy_status
 * @property string|null $created_time
 * @property string|null $updated_time
 * @property int|null $created_by
 * @property int|null $updated_by
 */
class ItEasyWarehouse extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_warehouse';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_warehouse_pincode',
            'it_easy_warehouse_city', 'it_easy_warehouse_state','it_easy_warehouse_email',
            'it_easy_warehouse_mobile','it_easy_warehouse_name', 'it_easy_warehouse_code','it_easy_warehouse_address', 
            'it_easy_warehouse_type'], 'required'],
            [['created_time', 'updated_time'], 'safe'],
            [['created_by', 'updated_by'], 'integer'],
            [['it_easy_warehouse_code', 'it_easy_warehouse_name', 'it_easy_warehouse_type'], 'string', 'max' => 80],
            [['it_easy_warehouse_code'], 'string', 'max' => 30],
            [['it_easy_warehouse_mobile'], 'string', 'min'=>10, 'max' => 13],
            [['it_easy_warehouse_email'], 'string', 'max' => 100,],
            ['it_easy_warehouse_email','email'],
            [['it_easy_warehouse_address'], 'string', 'max' => 150],
            [['it_easy_warehouse_city', 'it_easy_warehouse_state'], 'string', 'max' => 30],
            [['it_easy_warehouse_pincode'], 'integer', 'max' => 999999],
            [['it_easy_product_quantity'], 'integer', 'max' => 999999],
            [['it_easy_status'], 'string', 'max' => 15],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_warehouse_id' => 'Warehouse ID',
            'it_easy_warehouse_code' => 'Warehouse Code',
            'it_easy_warehouse_name' => 'Warehouse Name',
            'it_easy_warehouse_mobile' => 'Warehouse Mobile',
            'it_easy_warehouse_email' => 'Warehouse Email',
            'it_easy_warehouse_address' => 'Warehouse Address',
            'it_easy_warehouse_city' => 'Warehouse City',
            'it_easy_warehouse_state' => 'Warehouse State',
            'it_easy_warehouse_pincode' => 'Warehouse Pincode',
            'it_easy_warehouse_type' => 'Warehouse Type',
            'it_easy_product_quantity' => 'Product Quantity',
            'it_easy_status' => 'Status',
            'created_time' => 'Created Time',
            'updated_time' => 'Updated Time',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
        ];
    }
}
