<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_xpressbees_pincodes".
 *
 * @property int $it_easy_id
 * @property int $it_easy_Pincode
 * @property string|null $it_easy_AreaCode
 * @property string|null $it_easy_process_code
 * @property string|null $it_easy_HubZoneName
 * @property string|null $it_easy_HubCity
 * @property string|null $it_easy_HubState
 * @property string|null $it_easy_COD
 * @property string|null $it_easy_Prepaid
 * @property string|null $it_easy_metro_city
 * @property string|null $it_easy_delivery_estimate
 * @property string|null $it_easy_HasReversePickUpService
 * @property int|null $created_by
 * @property string $created_time
 * @property int|null $updated_by
 * @property string|null $updated_time
 * @property string $it_easy_date_added
 */
class ItEasyXpressbeesPincodes extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_xpressbees_pincodes';
    }

    /**
     * {@inheritdoc}
     */
    public $file;
    public function rules()
    {
        return [
            [['it_easy_Pincode', 'it_easy_date_added'], 'required'],
            [['it_easy_Pincode', 'created_by', 'updated_by'], 'integer'],
            [['created_time', 'updated_time', 'it_easy_date_added'], 'safe'],
            [['it_easy_AreaCode', 'it_easy_HubZoneName', 'it_easy_HubCity', 'it_easy_HubState'], 'string', 'max' => 255],
            [['it_easy_process_code'], 'string', 'max' => 80],
            [['it_easy_COD', 'it_easy_Prepaid', 'it_easy_HasReversePickUpService'], 'string', 'max' => 10],
            [['it_easy_metro_city'], 'string', 'max' => 40],
            [['file'], 'file', 'extensions' => 'csv', 'checkExtensionByMimeType'=>false, 'skipOnEmpty' => false],
            [['it_easy_delivery_estimate'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'Xpressbess ID',
            'it_easy_Pincode' => 'Xpressbess Pincode',
            'it_easy_AreaCode' => 'Xpressbess Area Code',
            'it_easy_process_code' => 'Xpressbess Process Code',
            'it_easy_HubZoneName' => 'Xpressbess Hub Zone Name',
            'it_easy_HubCity' => 'Xpressbess Hub City',
            'it_easy_HubState' => 'Xpressbess Hub State',
            'it_easy_COD' => 'Xpressbess Cod',
            'it_easy_Prepaid' => 'Xpressbess Prepaid',
            'it_easy_metro_city' => 'Xpressbess Metro City',
            'it_easy_delivery_estimate' => 'Xpressbess Delivery Estimate',
            'it_easy_HasReversePickUpService' => 'Xpressbess Has Reverse Pick Up Service',
            'created_by' => 'Created By',
            'created_time' => 'Created Time',
            'updated_by' => 'Updated By',
            'updated_time' => 'Updated Time',
            'it_easy_date_added' => 'Xpressbess Date Added',
        ];
    }
}
