<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyXpressbeesPincodes;

/**
 * ItEasyXpressbeesPincodesSearch represents the model behind the search form of `backend\models\ItEasyXpressbeesPincodes`.
 */
class ItEasyXpressbeesPincodesSearch extends ItEasyXpressbeesPincodes
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'it_easy_Pincode', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_AreaCode', 'it_easy_process_code', 'it_easy_HubZoneName', 'it_easy_HubCity', 'it_easy_HubState', 'it_easy_COD', 'it_easy_Prepaid', 'it_easy_metro_city', 'it_easy_delivery_estimate', 'it_easy_HasReversePickUpService', 'created_time', 'updated_time', 'it_easy_date_added'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyXpressbeesPincodes::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
            'pageSize' => 100,
        ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'it_easy_Pincode' => $this->it_easy_Pincode,
            'created_by' => $this->created_by,
            'created_time' => $this->created_time,
            'updated_by' => $this->updated_by,
            'updated_time' => $this->updated_time,
            'it_easy_date_added' => $this->it_easy_date_added,
        ]);

        $query->andFilterWhere(['like', 'it_easy_AreaCode', $this->it_easy_AreaCode])
            ->andFilterWhere(['like', 'it_easy_process_code', $this->it_easy_process_code])
            ->andFilterWhere(['like', 'it_easy_HubZoneName', $this->it_easy_HubZoneName])
            ->andFilterWhere(['like', 'it_easy_HubCity', $this->it_easy_HubCity])
            ->andFilterWhere(['like', 'it_easy_HubState', $this->it_easy_HubState])
            ->andFilterWhere(['like', 'it_easy_COD', $this->it_easy_COD])
            ->andFilterWhere(['like', 'it_easy_Prepaid', $this->it_easy_Prepaid])
            ->andFilterWhere(['like', 'it_easy_metro_city', $this->it_easy_metro_city])
            ->andFilterWhere(['like', 'it_easy_delivery_estimate', $this->it_easy_delivery_estimate])
            ->andFilterWhere(['like', 'it_easy_HasReversePickUpService', $this->it_easy_HasReversePickUpService]);

        return $dataProvider;
    }
}
