<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyZippyDtdcPincodes;

/**
 * ItEasyZippyPincodes represents the model behind the search form of `backend\models\ItEasyZippyPincodes`.
 */
class ItEasyZippyDtdcPincodesSearch extends ItEasyZippyDtdcPincodes
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id', 'it_easy_cod', 'it_easy_prepaid', 'created_by', 'updated_by'], 'integer'],
            [['it_easy_pincode', 'it_easy_carrier','it_easy_city', 'it_easy_state', 'it_easy_metro_city', 'it_easy_delivery_estimate', 'updated_time', 'created_time'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyZippyDtdcPincodes::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
            'pageSize' => 100,
        ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
            'it_easy_cod' => $this->it_easy_cod,
            'it_easy_prepaid' => $this->it_easy_prepaid,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'updated_time' => $this->updated_time,
            'created_time' => $this->created_time,
        ]);

        $query->andFilterWhere(['like', 'it_easy_pincode', $this->it_easy_pincode])
            ->andFilterWhere(['like', 'it_easy_city', $this->it_easy_city])
            ->andFilterWhere(['like', 'it_easy_state', $this->it_easy_state])
            ->andFilterWhere(['like', 'it_easy_metro_city', $this->it_easy_metro_city])
            ->andFilterWhere(['like', 'it_easy_delivery_estimate', $this->it_easy_delivery_estimate]);

        return $dataProvider;
    }
}
