<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "it_easy_zone_pincode".
 *
 * @property int $it_easy_id
 * @property string $it_easy_pincode
 * @property string $it_easy_zone_name
 * @property string|null $it_easy_city
 * @property string|null $it_easy_state
 * @property string $filecsv
 * @property string|null $created_time
 * @property int|null $created_by
 * @property string|null $updated_time
 * @property int|null $updated_by
 */
class ItEasyZonePincode extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'it_easy_zone_pincode';
    }

    /**
     * {@inheritdoc}
     */
    public $file;
    public function rules()
    {
        return [
            [['it_easy_pincode','it_easy_pickup_pincode'], 'required'],
            [['created_time', 'updated_time','file'], 'safe'],
            [['created_by', 'updated_by'], 'integer'],
            [['it_easy_pincode'], 'string', 'max' => 10],
            [['it_easy_zone_name'], 'string', 'max' => 20],
 [['file'], 'file', 'extensions' => 'csv', 'checkExtensionByMimeType'=>false, 'skipOnEmpty' => false],
            [['it_easy_city', 'it_easy_state'], 'string', 'max' => 60],
            

        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'it_easy_id' => 'ID',
            'it_easy_pincode' => 'Pincode',
            'it_easy_zone_name' => 'Zone Name',
            'it_easy_city' => 'City',
            'it_easy_state' => 'State',
            'it_easy_pickup_pincode'=>'Pickup Pincode',
            'created_time' => 'Created Time',
            'created_by' => 'Created By',
            'updated_time' => 'Updated Time',
            'updated_by' => 'Updated By',
        ];
    }
}
