<?php

namespace backend\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\ItEasyZonePincode;

/**
 * ItEasyZonePincodeSearch represents the model behind the search form of `backend\models\ItEasyZonePincode`.
 */
class ItEasyZonePincodeSearch extends ItEasyZonePincode
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['it_easy_id'], 'integer'],
            [['it_easy_pincode','it_easy_pickup_pincode', 'it_easy_zone_name', 'it_easy_city', 'it_easy_state'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = ItEasyZonePincode::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
            'pageSize' => 100,
        ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'it_easy_id' => $this->it_easy_id,
        ]);

        $query->andFilterWhere(['like', 'it_easy_pincode', $this->it_easy_pincode])
            ->andFilterWhere(['like', 'it_easy_zone_name', $this->it_easy_zone_name])
            ->andFilterWhere(['like', 'it_easy_city', $this->it_easy_city])
            ->andFilterWhere(['like', 'it_easy_state', $this->it_easy_state])
       		->andFilterWhere(['like', 'it_easy_pickup_pincode', $this->it_easy_pickup_pincode]);

        return $dataProvider;
    }
}
