<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "razor_payment".
 *
 * @property int $id
 * @property int $user_id
 * @property int $order_id
 * @property string $contact_number
 * @property string $payment_type
 * @property string $contact_email
 * @property string $payment_amount
 * @property string $payment_method
 * @property string $pay_id
 * @property string $pro_id
 * @property int $payment_string_response
 * @property string $created_time
 */
class RazorPayment extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'razor_payment';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['user_id', 'order_id', 'contact_number', 'payment_type', 'contact_email', 'payment_amount', 'payment_method', 'pay_id', 'pro_id', 'payment_string_response', 'created_time'], 'required'],
            [['user_id', 'order_id', 'payment_string_response'], 'integer'],
            [['created_time'], 'safe'],
            [['contact_number'], 'string', 'max' => 12],
            [['payment_type', 'payment_amount', 'payment_method', 'pay_id', 'pro_id'], 'string', 'max' => 55],
            [['contact_email'], 'string', 'max' => 155],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'user_id' => 'User ID',
            'order_id' => 'Order ID',
            'contact_number' => 'Contact Number',
            'payment_type' => 'Payment Type',
            'contact_email' => 'Contact Email',
            'payment_amount' => 'Payment Amount',
            'payment_method' => 'Payment Method',
            'pay_id' => 'Pay ID',
            'pro_id' => 'Pro ID',
            'payment_string_response' => 'Payment String Response',
            'created_time' => 'Created Time',
        ];
    }
}
