<?php

use backend\models\ItEasyApi;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyApiSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'It Easy Apis';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create API', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>

                            <div class="col-md-5">
                                 <?= $form->field($searchModel, 'api_type')->dropDownList([ 'SMS' => 'SMS', 'Email' => 'Email', 'Whatsapp' => 'Whatsapp', ], ['prompt' => 'Search By Api type'])->label(false) ?>
                            </div>
                            <div class="col-md-5">
                                <?= $form->field($searchModel, 'it_easy_api_name')->textInput(['maxlength' => true, 'placeholder' => 'Search By Api Name ....'])->label(false); ?>
                            </div>
                      

                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>
            <?= GridView::widget([
                'dataProvider' => $dataProvider,
                // 'filterModel' => $searchModel,
                'columns' => [
                    ['class' => 'yii\grid\SerialColumn'],

                    //'it_easy_id',
                    'api_type',
                    'it_easy_api_name',
                    //'it_easy_api_url:url',
                    'it_easy_api_username',
                    //'it_easy_api_password',
                    //'it_easy_api_key',
                    //'it_easy_api_port',
                    //'it_easy_status',
                    //'it_easy_created_time',
                    //'it_easy_updated_time',
                    //'it_easy_created_by',
                    //'it_easy_updated_by',
                     [
                'class' => ActionColumn::className(),
                'template' => '{update}',
                'urlCreator' => function ($action, ItEasyApi $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                }
                                ],
                ],
            ]); ?>


</div>
