<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use backend\models\ItEasyProductMaterial;
use kartik\date\DatePicker;
use yii\helpers\ArrayHelper;
use backend\models\ItEasyProductBatch;
use backend\models\ItEasyDepartment;
use backend\models\ItEasyProduct;
use backend\models\ItEasyProductVariationAttribute;
use common\models\User;
/** @var yii\web\View $this */
/** @var backend\models\ItEasyBuildHistory $model */

$this->title = 'Build Product History';
$this->params['breadcrumbs'][] = ['label' => 'Build Histories', 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => $model->it_easy_id, 'url' => ['view', 'it_easy_id' => $model->it_easy_id]];
$this->params['breadcrumbs'][] = 'Update';
?>
   <style type="text/css">
    .btn-main-greeenarry{
        background-color:#bdd51f !important;
        color: #fcfcfc;
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            
            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <div class="pr-1 mb-xl-0">
                        <a href="<?= BASE_URL ?>product-material"><button type="button" class="btn btn-info btn-icon mr-2" title="List-Page"><i class="icon ion-ios-list-box"></i></button></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->


    <?php $form = ActiveForm::begin(); ?>
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="main-content-label mg-b-5">
                        <?= Html::encode($this->title) ?>
                    </div>
            <p class="mg-b-20">Please create material history according to you !!</p>
        <div class="pd-30 pd-sm-40 bg-gray-200">
            <div class="row row-xs">
        <div class="col-md-4">
        <?= $form->field($model, 'it_easy_product_id')->dropDownList(
        ArrayHelper::map(ItEasyProduct::find()->select(['it_easy_product_id', 'it_easy_product_name'])->where(['it_easy_product_status' => 'Active'])->asArray()->all(),'it_easy_product_id','it_easy_product_name'),[
                 'prompt' => 'Please Select'])->label('Product Name') ?> 
        </div>
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_variation_id')->dropDownList(
        ArrayHelper::map(ItEasyProductVariationAttribute::find()->select(['it_easy_id', 'it_easy_variation_name'])->where(['it_easy_status' => 'Active'])->andWhere(['it_easy_id'=>$model->it_easy_variation_id])->asArray()->all(),'it_easy_id','it_easy_variation_name'),[
                 'prompt' => 'Please Select'])->label('Variation Name') ?>
        </div>
        <div class="col-md-4">
    <?= $form->field($model, 'it_easy_product_quantity')->textInput(['maxlength' => true]) ?>
        </div>
        </div>
        <div class="row row-xs">
        <div class="col-md-4">
   <?= $form->field($model, 'it_easy_added_by')->dropDownList(
        ArrayHelper::map(User::find()->select(['id', 'it_easy_firstname'])->where(['status' => 'Active'])->andWhere(['it_easy_dept_id'=>2])->asArray()->all(),'id','it_easy_firstname'),[
                 'prompt' => 'Please Select'])->label('Product Added By') ?>
        </div>
        <div class="col-md-4">
    <?php echo '<label>Produt Received Date</label>'; ?>
        <?= DatePicker::widget([
        'name' => 'ItEasyBuildHistory[it_easy_build_date]', 
        'value' => "$model->it_easy_build_date",
        'pluginOptions' => [
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true
            ]
        ]) ?>
        </div>
        <div class="col-md-4">
     <?= $form->field($model, 'it_easy_product_batch_id')->dropDownList(
        ArrayHelper::map(ItEasyProductBatch::find()->select(['it_easy_id', 'it_easy_batch'])->asArray()->all(),'it_easy_id','it_easy_batch'),[
                 'prompt' => 'Please Select'])->label('Product Batch') ?>
        </div>
        </div>

    
<div id="materialHtml">
	<?php
	 $count = count($model2);
	 $match = $count - 1;
     $remove = $count;
     // echo "<pre>";print_r($remove);die;
	 foreach ($model2 as $key => $value) {
	 ?>
    <div class="row row-xs remove<?= $key ?>">
        <div class="col-sm-4">
            <div class="form-group">
               <?= $form->field($value, '['.$key.']it_easy_material_id')->dropDownList(
        ArrayHelper::map(ItEasyProductMaterial::find()->select(['it_easy_id', 'it_easy_material_name'])->where(['it_easy_status' => 'Active'])->asArray()->all(),'it_easy_id','it_easy_material_name'),[
                 'prompt' => 'Select Material'])->label('Material Name') ?>
            </div>

            <input type="hidden" name="ItEasyBuildIngredient[<?= $key ?>][it_easy_id]" value='<?= $value['it_easy_id']; ?>'>
           
        </div>
        <div class="col-sm-4">
            <div class="form-group">
                <?= $form->field($value, '['.$key.']it_easy_add_quantity')->textInput(['value' => $value['it_easy_add_quantity']]) ?>
            </div>
        </div>
        <div class="col-sm-2">
            <div class="form-group">
                  <?= $form->field($value, '['.$key.']it_easy_weight_type')->dropDownList([''=>'Select','kilogram' => 'Kilogram', 'gram' => 'Gram', 'milligram' => 'Milligram', 'liter' => 'Liter', 'pound' => 'Pound'],['value' => $value['it_easy_weight_type']]); ?>
            </div>
        </div>
        <?php if($match == $key): ?>
        <div class="col-sm-1">
            <div class="form-group">
                <div style="margin-top: 28px;">
                    <a href="javascript:void(0);" class="hide<?= $key; ?>"  onclick="addMoreMaterial(<?= $key ?>);"  style="font-size:90%" class="label label-primary"><li class="icons-list-item"><i class="fa fa-plus-circle"></i></li></a>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php
    $i = 0;
     if($i++ < $key): ?>
            <div class="col-sm-1">
            <div class="form-group">
                <div style="margin-top: 4px;">
                    <a href="javascript:void(0);" style="padding-left:10px;" title="Delete" onclick="removeUpdateDiv('<?= $key; ?>');"><li class="icons-list-item"><i class="fa fa-times-circle"></i></li></a>
                </div>

            </div>
        </div>
    <?php endif; ?>
    </div>
  <?php } ?>
</div>
        <div class="row row-xs">
        <div class="col-md-12">
              <div class="col-md-1">
                <?= Html::submitButton('Save', ['class' => 'btn btn-dark btn-block']) ?>
                </div>
                <div class="col-md-1">
         
            <?= Html::a('Cancel', ['index'], ['class' => 'btn bg-maroon btn-flat btn btn btn-danger','onclick' => 'return confirm("Are you sure? You want to Exit?");']) ?>
                </div>
            </div>
            </div>
                 </div>
                </div>
                </div>
            </div>
        </div>
        
  
    <?php ActiveForm::end(); ?>

</div>
