<?php

use backend\models\ItEasyBuyProduct;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use backend\models\ItEasyProductVariationAttribute;

use common\models\User;
use kartik\daterange\DateRangePicker;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyUserTypeSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Buy Product';
$this->params['breadcrumbs'][] = $this->title;
?>
<style type="text/css">
    .form-control{
        /*background-color:#d3d8fb;*/
        border-right: none;
        border-left: none;
        border-top: none; 
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            
            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create Buy Product', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'],'method' => 'get']); ?>
                            <div class="col-md-4">
                                <?= $form->field($searchModel, 'it_easy_vendor_name')->textInput(['maxlength' => true, 'placeholder' => 'Search By Vendor Name....'])->label(false); ?>
                            </div>
                        <div class="col-md-4">
                             <?= $form->field($searchModel, 'it_easy_product_name')->textInput(['maxlength' => true, 'placeholder' => 'Search By Product Name....'])->label(false); ?>
                            </div>

                            <div class="col-md-4">
                        <?= $form->field($searchModel, 'it_easy_variation_id')->dropDownList(
                        ArrayHelper::map(ItEasyProductVariationAttribute::find()->select(['it_easy_id', 'it_easy_variation_name'])->where(['it_easy_status' => 'Active'])->asArray()->all(),'it_easy_id','it_easy_variation_name'),[
                                 'prompt' => 'Search By Variation Name'])->label(false) ?>
                            </div>

                          <div class="col-md-4">
                        <?= DateRangePicker::widget([
                                'model'=>$searchModel,
                                'attribute'=>'it_easy_received_date',
                                'options' => ['placeholder' => 'Search By Received date ...','class'=>'form-control'],
                                'convertFormat'=>true,
                                'pluginOptions'=>[
                                    'timePicker'=>true,
                                    'timePickerIncrement'=>30,
                                    'locale'=>[
                                        'format'=>'Y/m/d'
                                    ]
                                ]
                            ]); ?>
                            </div>

                            <div class="col-md-4">
                     <?= $form->field($searchModel, 'it_easy_received_by')->dropDownList(
                        ArrayHelper::map(User::find()->select(['id', 'it_easy_firstname'])->where(['status' => 'Active'])->asArray()->all(),'id','it_easy_firstname'),[
                                 'prompt' => 'Please Search Received By '])->label(false) ?>
                        </div>

                         <div class="col-md-4">
                                <?= $form->field($searchModel, 'it_easy_approved_status')->dropDownList([''=>'Search By Approved Status', 'Approved' => 'Approved', 'Pending' => 'Pending'],  ['class'=>'form-control'])->label(false);; ?>
                        </div>

                           
                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,
                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],

                                // 'it_easy_id',
                                // 'it_easy_vendor_id',
                                'it_easy_vendor_name',
                                // 'it_easy_product_id',
                                'it_easy_product_name',

                                // 'it_easy_variation_id',

                                 [
                           'label' => 'Vendor Name',
                           'attribute' => 'it_easy_variation_id',
                           'value' => function ($model) {
                                $variation_name = ItEasyProductVariationAttribute::find()->select(['it_easy_id', 'it_easy_variation_name'])->where(['it_easy_id' => $model->it_easy_variation_id ])->asArray()->one(); 
                                return $variation_name['it_easy_variation_name'];
                                   }
                                ],

                                'it_easy_product_quantity',
                                //'it_easy_invoice_number',
                                //'it_easy_per_bottle_price',
                                //'it_easy_total_price',
                                //'it_easy_gst_amount',
                                //'it_easy_gst_type',
                                'it_easy_received_date',
                                // 'it_easy_received_by',
                                'it_easy_approved_status',
                                //'it_easy_buy_month',
                                //'it_easy_buy_year',
                                //'created_time',
                                //'updated_time',
                                //'created_by',
                                //'updated_by',
                        //    [
                        //     'class' => ActionColumn::className(),
                        //     'template' => '{update}',
                        //     'urlCreator' => function ($action, ItEasyBuyProduct $model, $key, $index, $column) {
                        //         return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                        //      }
                        // ],

                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
    </div>
</div>






