<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyChanel $model */
/** @var yii\widgets\ActiveForm $form */
?>

<style type="text/css">
    .btn-main-greeenarry {
        background-color: #bdd51f !important;
        color: #fcfcfc;
    }
</style>
<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">
            
            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <div class="pr-1 mb-xl-0">
                        <a href="<?= BASE_URL ?>chanel"><button type="button" class="btn btn-info btn-icon mr-2" title="List-Page"><i class="icon ion-ios-list-box"></i></button></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <?php $form = ActiveForm::begin(); ?>
    <div class="row">
        <div class="col-lg-12 col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="main-content-label mg-b-5">
                        <?= Html::encode($this->title) ?>
                    </div>

                    <div class="pd-30 pd-sm-40 bg-gray-200">
                        <div class="row row-xs">
                            <div class="col-md-4">
                                <?= $form->field($model, 'fetch_Type')->dropDownList(['Auto' => 'Auto', 'Manual' => 'Manual',]) ?>
                            </div>

                            <div class="col-md-4">
                                <?= $form->field($model, 'channel_name')->dropDownList(['Shopify'=> 'Shopify', 'Woocommerce' => 'Woocommerce'],['maxlength' => true, 'prompt' => 'Search By Chanel Name']); ?>
                            </div>

                            <div class="col-md-4">
                                <?= $form->field($model, 'shop_url')->textInput(['maxlength' => true]) ?>
                            </div>

                            <div class="col-md-4">
                                <?= $form->field($model, 'api_key')->textInput(['maxlength' => true]) ?>
                            </div>

                            <div class="col-md-4">
                                <?= $form->field($model, 'api_secret')->textInput(['maxlength' => true]) ?>
                            </div>

                            <div class="col-md-4">
                                <?= $form->field($model, 'api_password')->textInput(['maxlength' => true]) ?>
                            </div>

                            <div class="col-md-12">
                                <?= $form->field($model, 'status')->dropDownList(['Active' => 'Active', 'Inactive' => 'Inactive',]) ?>
                            </div>
							
                            <div class="row row-xs">
                                <div class="col-md-12">
                                    <div class="col-md-6">
                                        <?= Html::submitButton('Save', ['class' => 'btn btn-dark btn-block']) ?>
                                    </div>
                                    <div class="col-md-6">

                                        <?= Html::a('Cancel', ['index'], ['class' => 'btn bg-maroon btn-flat btn btn btn-danger', 'onclick' => 'return confirm("Are you sure? You want to Exit?");']) ?>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>
        </div>


        <?php ActiveForm::end(); ?>

    </div>