<?php

use backend\models\ItEasyChanel;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyChanelSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'CHANNEL';
$this->params['breadcrumbs'][] = $this->title;
?>

<style type="text/css">
    .form-control {
        /*background-color:#d3d8fb;*/
        border-right: none;
        border-left: none;
        border-top: none;
    }
</style>
<!-- container -->

<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <div class="btn-group dropdown">
                    <?= Html::a('Create Channel', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div>
            </div>
        </div>


        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>



                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'fetch_Type')->dropDownList(['Auto' => 'Auto', 'Manual' => 'Manual',], ['prompt' => 'Search by fetch type'])->label(false); ?>
                            </div>

                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'channel_name')->dropDownList(['Shopify'=> 'Shopify', 'Woocommerce' => 'Woocommerce'],['maxlength' => true, 'prompt' => 'Search By Chanel Name'])->label(false); ?>
                            </div>

                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'status')->dropDownList(['Active' => 'Active', 'Inactive' => 'Inactive',], ['prompt' => 'Search by status'])->label(false) ?>
                            </div>



                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                            </div>

                            <?php ActiveForm::end(); ?>

                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <br>
                        <br>

                        <div class="it-easy-chanel-index">
                            <?php // echo $this->render('_search', ['model' => $searchModel]); 
                            ?>

                            <?= GridView::widget([
                                'dataProvider' => $dataProvider,
                                // 'filterModel' => $searchModel,
                                'columns' => [
                                    ['class' => 'yii\grid\SerialColumn'],

                                    // 'id',
                                    'fetch_Type',
                                    'channel_name',
                                    'shop_url:url',
                                    'api_key',
                                    //'api_secret',
                                    //'api_password',
                                    //'status',
                                    //'created_by',
                                    //'updated_by',
                                    //'created_time',
                                    //'updated_time',
                                    [
                                        'class' => ActionColumn::className(),

                                        'template' => '{update}',
                                        'urlCreator' => function ($action, ItEasyChanel $model, $key, $index, $column) {
                                            return Url::toRoute([$action, 'id' => $model->id]);
                                        }
                                    ],
                                ],
                            ]); ?>


                        </div>
                    </div>
                </div>
            </div>
            <!--/div-->
        </div>
    </div>