<?php

use backend\models\ItEasyCustomer;
use backend\models\ItEasyDiseasesName;
use backend\models\ItEasyDiseasesNameSearch;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use yii\helpers\ArrayHelper;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyCustomerSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = ' Customers';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">
                <!-- <div class="btn-group dropdown">
                    <? // Html::a('Create Customer', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
                </div> -->
            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>
                            <div class="col-md-3">
                             
                            </div>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_disease_name')->dropDownList($get_disease_name, ['prompt' => 'Search Disease Name....'])->label(false); ?>
                            </div>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_mobile_number')->textInput(['maxlength' => true, 'placeholder' => 'Search Mobile Number....'])->label(false); ?>
                            </div>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_city')->textInput(['placeholder' => 'Search City....'])->label(false) ?>
                            </div>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_state')->dropDownList(['Delhi' => 'Delhi', 'Punjab' => 'Punjab', 'Mumbai' => 'Mumbai'], ['prompt' => 'Search by State Name'])->label(false) ?>
                            </div>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_pincode')->textInput(['placeholder' => 'Search Pincode....'])->label(false) ?> 
                            </div>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_order_ids')->textInput(['placeholder' => 'Search Order ID....'])->label(false) ?> 
                            </div>
                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_status')->dropDownList(['Active' => 'Active', 'Blocked' => 'Blocked'], ['prompt' => 'Search by Status'])->label(false) ?>
                            </div>
                            <div class="col-md-3">
                               
                                <?= $form->field($searchModel, 'created_time')->widget(
                                    DatePicker::classname(),

                                    [
                                        'name' => 'created_time',

                                        'value' => date('yyyy-mm-dd'),
                                        'options' => ['placeholder' => 'Enter Create Date ...'],
                                        'pluginOptions' => [
                                            'format' => 'yyyy-mm-dd',
                                           
                                            'todayHighlight' => true
                                        ]
                                    ]
                                )->label(false);
                                ?>

                            </div>
                            <div class="col-md-2" style="float: right;">
                            <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                        </div>

                        </div>
                       
                     
                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <br>
                    <br>

                    <?= GridView::widget([
                        'dataProvider' => $dataProvider,
                        // 'filterModel' => $searchModel,
                        'columns' => [
                            ['class' => 'yii\grid\SerialColumn'],

                             [  'label'=>'Disease Name',
                                'attribute'=>'it_easy_disease_name',
                                'value'=>function($model){
                                    if(!empty($model->it_easy_disease_name)){
                                        $diseasearray_name = explode(',', $model->it_easy_disease_name);
                                        $Diseasename=ItEasyDiseasesName::find()->select(['it_easy_name'])->where(['IN',  'it_easy_id' ,$diseasearray_name])->asArray()->all();
                                        $return_disease_name = '';
                                        foreach($Diseasename as $key => $diseas){
                                            if($key == '0'){
                                                $return_disease_name = $diseas['it_easy_name'];
                                            }else{
                                                $return_disease_name .= ', '.$diseas['it_easy_name'];
                                            }
                                        }
                                        return $return_disease_name;
                                    }else{
                                        return '';
                                    }

                                }

                             ],
                             
                            'it_easy_firstname',
                            'it_easy_mobile_number',
                            'it_easy_city',
                            'it_easy_state',
                            'it_easy_pincode',
                            'it_easy_status',
                            'created_time',
                            
                        ],
                    ]); ?>
                </div>
            </div>
        </div>
    </div>
    <!--/div-->
</div>
</div>