<?php


use backend\models\ItEasyOrder;
use backend\models\ItEasyDiseasesName;
use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use yii\helpers\ArrayHelper;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyOrderSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Disease Type Order';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- container -->
<div class="container-fluid">

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
        <div class="d-flex my-xl-auto right-content">

            <div class="mb-xl-0">


            </div>
        </div>
    </div>
    <!-- breadcrumb -->

    <!-- row opened -->
    <div class="row row-sm">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header pb-0">
                    <div class="row">
                        <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                            <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>

                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'it_easy_disease_name')->dropDownList(ArrayHelper::map(ItEasyDiseasesName::find()->asArray()->all(), 'it_easy_id', 'it_easy_name'), ['prompt' => 'Select Disease'])->label(false) ?>
                            </div>

                            <div class="col-md-3">
                                <?= $form->field($searchModel, 'date_type_filter')->dropDownList(['Date Added' => 'Date Added', 'Date Modified' => 'Date Modified', 'Date Assigned' => 'Date Assigned', 'Date Converted' => 'Date Converted', 'Date Dispatched' => 'Date Dispatched', 'Date Delivered' => 'Date Delivered'], ['prompt' => 'Search by Date Type'])->label(false); ?>
                            </div>

                            
                            <div class="col-md-3">
                                <div class="form-group field-iteasydiseasetype-date_from_date">
                                    <?= DatePicker::widget([
                                        'name' => 'ItEasyDiseaseType[date_from_date]',
                                        'value' => $searchModel->date_from_date,
                                        'options' => ['placeholder' => 'Start date', 'id' => 'iteasydiseasetype-date_from_date', 'autoComplete' => 'off'],
                                        'pluginOptions' => [
                                            'format' => 'yyyy-mm-dd',
                                            'todayHighlight' => true,
                                            'autoclose' => true,
                                            'placeholder' => 'Search by Start date'
                                        ]
                                    ]) ?>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="form-group field-iteasydiseasetype-date_to_date">
                                    <?= DatePicker::widget([
                                        'name' => 'ItEasyDiseaseType[date_to_date]',
                                        'value' => $searchModel->date_to_date,
                                        'options' => ['placeholder' => 'End date', 'id' => 'iteasydiseasetype-date_to_date', 'autoComplete' => 'off'],
                                        'pluginOptions' => [
                                            'format' => 'yyyy-mm-dd',
                                            'todayHighlight' => true,
                                            'autoclose' => true,
                                            'placeholder' => 'Search by End date'
                                        ]
                                    ]) ?>
                                </div>
                            </div>



                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_assigned_by')->dropDownList($tl_data, [ 'prompt' => 'Search by TL Name'])->label(false); ?>
                            </div>
                            <div class="col-md-2">
                                <?= $form->field($searchModel, 'it_easy_assigned_to')->dropDownList($agent_data, [ 'prompt' => 'Search by Agent Name'])->label(false); ?>
                            </div>
                            <div class="col-md-2">
                                
                                <?= $form->field($searchModel, 'it_easy_state_id')->dropDownList($statedata, [ 'prompt' => 'Search by State Name'])->label(false); ?>
                            </div>
                            <div class="col-md-2">
                                
                                <?= $form->field($searchModel, 'it_easy_first_status')->dropDownlist(['Lead' => 'Lead', 'COD' => 'COD', 'Prepaid' => 'Prepaid'], ['prompt' => 'Search by First Status'])->label(false); ?>
                            </div>


                            <div class="col-md-2" style="float: right;">
                                <?= Html::submitButton('Filter', ['class' => 'btn btn-secondary-gradient btn-block']) ?>
                            </div>


                            <?php ActiveForm::end(); ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive border-top userlist-table">
                        <br>
                        <br>
                        <?= GridView::widget([
                            'dataProvider' => $dataProvider,
                            // 'filterModel' => $searchModel,


                            'columns' => [
                                ['class' => 'yii\grid\SerialColumn'],
                                [
                                    'label' => 'Order-Number',
                                    'format' => 'raw',
                                    'attribute' => 'it_easy_order_number',
                                    'contentOptions' => ['style' => 'background-color:#123146;color: #fcfcfc;font-size: 16px;line-height: 25px;'],

                                    'value' => function ($model) {

                                        $get_status_name = ItEasyOrder::GetOrderStatusNamebystatusId($model->it_easy_order_status_id);
                                        return '<b>' . $model->it_easy_order_number . '<br>' . $model->it_easy_other_order_id . '</b><br>' . $model->it_easy_first_status . '<br>' . $get_status_name;
                                    }
                                ],

                                 [  'label'=>'Disease Name',
                                    'attribute'=>'it_easy_disease_name',
                                    'value'=>function($model){
                                        if(!empty($model->it_easy_disease_name)){
                                            $diseasearray_name = explode(',', $model->it_easy_disease_name);
                                            $Diseasename=ItEasyDiseasesName::find()->select(['it_easy_name'])->where(['IN',  'it_easy_id' ,$diseasearray_name])->asArray()->all();
                                            $return_disease_name = '';
                                            foreach($Diseasename as $key => $diseas){
                                                if($key == '0'){
                                                    $return_disease_name = $diseas['it_easy_name'];
                                                }else{
                                                    $return_disease_name .= ', '.$diseas['it_easy_name'];
                                                }
                                            }
                                            return $return_disease_name;
                                        }else{
                                            return '';
                                        }

                                    }

                                 ],
                                [
                                    'label' => 'Customer-Info',
                                    'format' => 'raw',
                                    'attribute' => 'it_easy_firstname',
                                    'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                    'value' => function ($model) {

                                        return $model->it_easy_firstname . ' ' . $model->it_easy_lastname . '<br>' . $model->it_easy_mobile_number . '<br>' . $model->it_easy_email;
                                    }
                                ],

                                [
                                    'label' => 'Address',
                                    'format' => 'raw',
                                    'attribute' => 'it_easy_city',
                                    'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                    'value' => function ($model) {

                                        return $model->it_easy_city . '<br>' . $model->it_easy_state . '<br>' . $model->it_easy_pincode;
                                    }
                                ],
                                [
                                    'label' => 'Course Duration',
                                    'format' => 'raw',
                                    'attribute' => 'it_easy_course_duration',
                                    'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                    'value' => function ($model) {

                                        return $model->it_easy_course_duration;
                                    }
                                ],


                                [
                                    'label' => 'Serviceable',
                                    'format' => 'raw',
                                    'attribute' => 'it_easy_order_serviceable',
                                    'contentOptions' => ['style' => 'line-height: 20px;font-size: 14px;padding:12px;'],
                                    'value' => function ($model) {
                                        if (!empty($model->it_easy_order_serviceable)) {
                                            $get_serviceable_name = ItEasyOrder::GetServiceableCourierName($model->it_easy_order_serviceable);
                                            $str_serviceable = '';
                                            if (!empty($get_serviceable_name)) {
                                                $count_serviceable = count($get_serviceable_name);
                                                $check_serviceable = $count_serviceable - 1;
                                                foreach ($get_serviceable_name as $key => $service) {
                                                    if ($key == $check_serviceable) {
                                                        $str_serviceable .= $service->it_easy_name;
                                                    } else {
                                                        $str_serviceable .= $service->it_easy_name . '<br>';
                                                    }
                                                }
                                            }
                                            return $str_serviceable;
                                        } else {
                                            return '';
                                        }
                                    }
                                ],

                                [
                                    'label' => 'Delivered Time',
                                    'format' => 'raw',
                                    'attribute' => 'it_easy_delivered_time',
                                    'value' => function ($model) {
                                        return date('Y-m-d', strtotime($model->it_easy_created_time)) . '<br>' . date('H:i:s', strtotime($model->it_easy_created_time));
                                    }
                                ],


                

                            ],
                        ]); ?>
                    </div>
                </div>
            </div>
        </div>
        <!--/div-->
    </div>
</div>