<?php

use backend\models\ItEasyOrder;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyOrderSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Courier Data Analysis Report';
$this->params['breadcrumbs'][] = $this->title;
?>
<style type="text/css">

  .bg-gray-200{
    border-radius: 8px; 
  }
  .font-weight-bold{
      color: #2cac81;
      font-size: 18px;
      font-weight: bolder;
      font-family: cursive;
  }
  .mb-1{
    font-weight: 700;
    font-size: 12px;
    margin-top: 15px;
  }
  .card-order-total{
    border-radius: 0px !important;
    border: none !important;
  }
  textarea{
    border-radius: 10px !important;
    background-color: #ffffff !important;
    border: 2px solid #fdfdfd !important;
  }
  th{
    font-size: 16px !important;
    font-family: monospace;
    font-weight: bolder !important;
    text-align: center !important;
  }
</style>
<!-- container -->
<div class="container-fluid">

    <div class="row row-sm" style="margin-top: 40px;
    background: #edecec;
    padding-top: 20px;
    border-radius: 9px;">
          <div class="col-xl-1 col-md-1"> </div>
        <div class="col-xl-11 col-md-11">
              <div class="col-md-12">
    <?php $formsearch = ActiveForm::begin(['action' => ['index'],'method' => 'get']); ?>
                
                    
                    <div class="col-md-4">
                        <?= $formsearch->field($searchModel, 'date_type_filter')->dropDownList(['Date Dispatched' => 'Date Dispatched','Date Added' => 'Date Added', 'Date Modified' => 'Date Modified', 'Date Assigned' => 'Date Assigned', 'Date Converted' => 'Date Converted',  'Date Delivered' => 'Date Delivered'])->label(false); ?>
                    </div>
                <div class="col-md-3">
                <div class="form-group field-iteasyordersearch-date_from_date">
                  <?= DatePicker::widget([
                  'name' => 'ItEasyOrderSearch[date_from_date]', 
                  'value' => empty($searchModel->date_from_date) ? date('Y-m-d') : $searchModel->date_from_date,
                  'options' => ['placeholder' => 'From date', 'id' => 'iteasyordersearch-date_from_date'],
                  'pluginOptions' => [
                  'format' => 'yyyy-mm-dd',
                  'todayHighlight' => true,
                  'autoclose' => true,
                  'placeholder' => 'Search by From date'
                      ]
                  ]) ?>
                </div>
                </div>
                <div class="col-md-3">
                <div class="form-group field-iteasyordersearch-date_to_date">
                    <?= DatePicker::widget([
                    'name' => 'ItEasyOrderSearch[date_to_date]', 
                    'value' => empty($searchModel->date_to_date) ? date('Y-m-d') : $searchModel->date_to_date,
                    'options' => ['placeholder' => 'To date', 'id' => 'iteasyordersearch-date_to_date'],
                    'pluginOptions' => [
                    'format' => 'yyyy-mm-dd',
                    'todayHighlight' => true,
                    'autoclose' => true,
                        ]
                    ]) ?>
                </div>
                </div>
            
            <div class="col-md-2">
                <?= Html::submitButton('Search', ['class' => 'btn btn-secondary btn-block']) ?>
            </div>
      <?php ActiveForm::end(); ?>
              <br>
              <h4 style="float: right; color: #3e3e6e;font-family: ui-monospace;">by default This Month data</4>
            <br>
            </div>
             
        </div>
      </div>


        <div class="col-md-12" style="padding: 15px;">
          <div class="col-md-12 col-lg-12 col-xl-12">
              <div class="card card-table-two">
                  <div class="d-flex justify-content-between">
                      <h4 class="card-title mb-1">Courier Wise Dispatch Count</h4>
                      <i class="mdi mdi-dots-horizontal text-gray"></i>
                  </div>
              
                  <div class="table-responsive country-table">
                      <table class="table table-striped table-bordered mb-0 text-sm-nowrap text-lg-nowrap text-xl-nowrap">
                          <thead>
                              <tr>
                                  <th class="wd-lg-20p">Courier Name</th>
                                  <th class="wd-lg-20p tx-right">Dispatch Order Count</th>
                                  <th class="wd-lg-20p tx-right">Dispatch Order Sum</th>
                                  
                              </tr>
                       
                          </thead>
                          <tbody>

                          <?php if(!empty($courierwiseReport)){
                          		$total =0; 
                          		$total_dispatch_amt =0;
                              foreach ($courierwiseReport as $key => $courier_value){
                              	// echo "<pre>";print_r($courier_value['dispatched_order_count']);die;
                              	$total += $courier_value['dispatched_order_count'] ;
                              	$total_dispatch_amt += $courier_value['dispatched_order_sum'] ;
                              	 ?>  
                              <tr>
                                  <th class="wd-lg-20p"><?=  $courier_value['courier_name']; ?></th>
                                  
                                  <th class="wd-lg-20p tx-right"><span class="font-weight-bold"><?=  $courier_value['dispatched_order_count']; ?></span></th>
                                  
                                  <th class="wd-lg-20p tx-right"><span class="font-weight-bold"><?=  $courier_value['dispatched_order_sum']; ?></span></th>
                                 
                                 
                              </tr>

                          <?php } ?>
                          	<tr>
                                  <th class="wd-lg-20p" style="color: #ec7118;">TOTAL</th>
                                  
                                  <th class="wd-lg-20p tx-right"><span class="font-weight-bold"><?= $total ?></span></th>
                                  <th class="wd-lg-20p tx-right"><span class="font-weight-bold"><?= $total_dispatch_amt ?></span></th>
                                 
                                 
                              </tr>
                    <?php  } ?>    
                          </tbody>
                      </table>
                  </div>
              </div>
          </div>

        </div>



        <div class="col-md-12" style="padding: 15px;">
          <div class="col-md-12 col-lg-12 col-xl-12">
              <div class="card card-table-two">
                  <div class="d-flex justify-content-between">
                      <h4 class="card-title mb-1">Product Wise Dispatch Count</h4>
                      <i class="mdi mdi-dots-horizontal text-gray"></i>
                  </div>
              
                  <div class="table-responsive country-table">
                      <table class="table table-striped table-bordered mb-0 text-sm-nowrap text-lg-nowrap text-xl-nowrap">
                          <thead>
                              <tr>
                                  <th class="wd-lg-20p">Product Name</th>
                                  <th class="wd-lg-20p">Variation Name</th>
                                  <th class="wd-lg-20p tx-right">Dispatch Order Count</th>
                                  
                              </tr>
                          </thead>
                          <tbody>

                          <?php if(!empty($productwiseReport)){ 
                          	$total =0;
                              foreach ($productwiseReport as $key => $product_value){ 
                              	$total += $product_value['dispatched_order_count'] ;
                              	?>  
                              <tr>
                                  <th class="wd-lg-20p"><?=  $product_value['product_name']; ?></th>
                                  <th class="wd-lg-20p"><?=  $product_value['variation_name']; ?></th>
                                  <th class="wd-lg-20p tx-right"><span class="font-weight-bold"><?=  $product_value['dispatched_order_count']; ?></span></th>
                                 
                              </tr>
                         <?php } ?>
                          	<tr>
                                  <th class="wd-lg-20p" style="color: #ec7118;">TOTAL</th>
                                  <th class="wd-lg-20p"></th>
                                  <th class="wd-lg-20p tx-right"><span class="font-weight-bold"><?= $total ?></span></th>
                                 
                                 
                              </tr>
                    <?php  } ?>     
                          </tbody>
                      </table>
                  </div>
              </div>
          </div>

        </div>

    </div>
   






