<?php

use backend\models\ItEasyEcomPincodes;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyEcomPincodesSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Ecom Pincodes';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="container-fluid">

<!-- breadcrumb -->
<div class="breadcrumb-header justify-content-between">
    <div class="my-auto">
        <div class="d-flex">
            <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
        </div>
    </div>
    <div class="d-flex my-xl-auto right-content">

        <div class="mb-xl-0">
            <div class="btn-group dropdown">
                <?= Html::a('Upload Ecom Pincodes', ['create'], ['class' => 'btn btn-dark btn-block']) ?>
            </div>
        </div>
    </div>
</div>
<!-- breadcrumb -->

<!-- row opened -->
<div class="row row-sm">
    <div class="col-xl-12">
        <div class="card">
            <div class="card-header pb-0">
                <div class="row">
                    <div class="col-md-12" style="background-color: #e2e2e2; border-radius: 15px; padding-top: 30px;padding-bottom: 30px;">
                        <?php $form = ActiveForm::begin(['action' => ['index'], 'method' => 'get']); ?>
                        <div class="col-md-3">
                            <?= $form->field($searchModel, 'it_easy_pincode')->textInput(['placeholder' => 'Search Pincode....'])->label(false) ?>
                        </div>
                        <div class="col-md-3">
                            <?= $form->field($searchModel, 'it_easy_area')->textInput(['maxlength' => true, 'placeholder' => 'Search Area Name....'])->label(false); ?>
                        </div>
                        <div class="col-md-3">
                            <?= $form->field($searchModel, 'it_easy_cod')->textInput(['maxlength' => true, 'placeholder' => 'Search COD....'])->label(false); ?>
                        </div>
                        <div class="col-md-3">
                            <?= $form->field($searchModel, 'it_easy_state')->textInput(['placeholder' => 'Search State....'])->label(false) ?>
                        </div>
                        <div class="col-md-3">
                            <?= $form->field($searchModel, 'it_easy_state_code')->textInput(['maxlength' => true, 'placeholder' => 'Search State Code....'])->label(false); ?>
                        </div>
                        <div class="col-md-3">
                            <?= $form->field($searchModel, 'it_easy_dccode')->textInput(['placeholder' => 'Search State Dccode....'])->label(false) ?>
                        </div>
                        <div class="col-md-3">
                            <?= $form->field($searchModel, 'it_easy_city_code')->textInput(['placeholder' => 'Search City Code....'])->label(false) ?>
                        </div>
                        <div class="col-md-3">
                            <?= $form->field($searchModel, 'it_easy_city_type')->textInput(['placeholder' => 'Search City Type....'])->label(false) ?>
                        </div>
                        <div class="col-md-2" style="float: right;">
                            <?= Html::submitButton('Filter', ['class' => 'btn btn-light btn-block']) ?>
                        </div>

                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <br>
                    <br>

                    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        // 'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'it_easy_id',
            'it_easy_pincode',
            'it_easy_area',
            'it_easy_cod',
            'it_easy_state',
            'it_easy_state_code',
            'it_easy_dccode',
            'it_easy_city_code',
            'it_easy_city_type',
            'it_easy_route',
            // 'it_easy_prepaid',
            // 'it_easy_metro_city',
            // 'it_easy_delivery_estimate',
            // 'it_easy_status',
            'active',
            //'created_by',
            //'updated_by',
            //'created_time',
            //'updated_time',
            [
                'class' => ActionColumn::className(),
                'template'=>'{update} {delete}',
                'urlCreator' => function ($action, ItEasyEcomPincodes $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'it_easy_id' => $model->it_easy_id]);
                 }
            ],
        ],
    ]); ?>
                </div>
            </div>
        </div>
    </div>
    <!--/div-->
</div>
</div>
