<?php

/** @var \yii\web\View $this */
/** @var string $content */

use backend\assets\AppAsset;
use common\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, 
    user-scalable=0">
    <?php $this->registerCsrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?= $this->head() ?>
    <?php include(dirname(__FILE__) . "/../common/allcss.php"); ?>
    <script> var JS_BASE_URL = '<?php echo BASE_URL; ?>'; </script>
</head>
<body class="hoversubmenu main-body app sidebar-mini">
    
<?php
$this->beginBody();

include(dirname(__FILE__) . "/../common/header.php");

?>
<?= $content ?>
<?php 
include(dirname(__FILE__) . "/../common/footer.php");
?>

<?php 
include(dirname(__FILE__) . "/../common/alljs.php");
$this->endBody() 
?>
</body>
</html>
<?php $this->endPage();
