<?php

/** @var \yii\web\View $this */
/** @var string $content */

use backend\assets\AppAsset;
use common\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, 
    user-scalable=0">
    <?php $this->registerCsrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?= $this->head() ?>
    <?php include(dirname(__FILE__) . "/../common/allcss.php"); ?>
    <script> var JS_BASE_URL = '<?php echo BASE_URL; ?>'; </script>
    <style type="text/css">
    	.col-md-4,.col-md-2,.col-md-8,.col-md-6,.col-md-3,.col-md-5,.col-md-7,.col-md-3,.col-md-1,.col-md-9,.col-md-10{
    		float: left;
    	}
    	thead{
    		height: 45px;
    		background-color: #9ba5ed;
    	}
    	th > a{
    		font-size: 14px;
    		color: #ffffff;
    	}
        .breadcrumb-header{
            padding: 10px;
            background-color: #f4f7fd;
            border-left: 6px solid #DCDCF5;
            border-radius: 3px;
        }
      .help-block{
        color:#f94747;
      }
      .my-auto > .d-flex > .content-title{
          font-size: 18px;font-weight: 900;color: #1F1F55;
      }
    </style>
</head>
<body class="hoversubmenu main-body app sidebar-mini">
 <div id="global-loader">
   <img src="<?= BASE_URL ?>img/loader.svg" class="loader-img" alt="Loader">
  </div> 
<?php
	$this->beginBody();
	include(dirname(__FILE__) . "/../common/sidebar.php");
?>
<div class="main-content app-content">
<?php

	include(dirname(__FILE__) . "/../common/header.php");

	?>
	<?= $content ?>

</div>	
	<?php 
	include(dirname(__FILE__) . "/../common/footer.php");
	?>

	<?php
    if(Yii::$app->controller->id != 'logistic' && Yii::$app->controller->id != 'site'){ 
	include(dirname(__FILE__) . "/../common/alljs.php");
    }
	$this->endBody() 
	?>

<script type="text/javascript">
$(document).on("change", "#iteasyorderproduct-it_easy_product_id", function () {  
    var csrfToken = $('meta[name="csrf-token"]').attr("content"); 
    var getproductid = $(this).val();
    $.ajax({
        url: JS_BASE_URL+'order/buyvariation',
        type: 'POST', 
        data: {_csrf : csrfToken, 'product_id' : getproductid},
        beforeSend: function() {
          $('#global-loader').show(); 
        },
        complete: function() {
          $('#global-loader').hide();

        },
        success: function(json) {  
            $('#iteasyorderproduct-it_easy_variation_id').html(json);
            return false;
        }
    });
});

</script>
<?php
if(Yii::$app->controller->action->id != 'manifest'){ ?>
<script type="text/javascript">
    $(document).on('beforeSubmit', 'form', function(event) {
        $(this).find('[type=submit]').attr('disabled', true).addClass('disabled');
    });
</script>
<?php } ?>

</body>
</html>
<?php $this->endPage();
