<?php

/** @var \yii\web\View $this */
/** @var string $content */

use backend\assets\AppAsset;
use common\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, 
    user-scalable=0">
    <?php $this->registerCsrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?= $this->head() ?>
    <?php include(dirname(__FILE__) . "/../common/allcss.php"); ?>
    <script> var JS_BASE_URL = '<?php echo BASE_URL; ?>'; </script>
    <style type="text/css">
    	.col-md-4,.col-md-2,.col-md-8,.col-md-6,.col-md-3,.col-md-5,.col-md-7,.col-md-3,.col-md-1,.col-md-9,.col-md-10{
    		float: left;
    	}
    	thead{
    		height: 45px;
    		background-color: #9ba5ed;
    	}
    	th > a{
    		font-size: 14px;
    		color: #ffffff;
    	}
      .help-block{
        color:#f94747;
      }
      .form-control{
           border: 2px solid #fff;
        }
    </style>
</head>
<body class="hoversubmenu main-body app sidebar-mini">
 <div id="global-loader">
   <img src="<?= BASE_URL ?>img/loader.svg" class="loader-img" alt="Loader">
  </div> 
<?php
	$this->beginBody();
	include(dirname(__FILE__) . "/../common/sidebar.php");
?>
<div class="main-content app-content">
<?php

	include(dirname(__FILE__) . "/../common/header.php");

	?>
	<?= $content ?>

</div>	
	<?php 
	include(dirname(__FILE__) . "/../common/footer.php");
	?>

	<?php 
	include(dirname(__FILE__) . "/../common/alljs.php");
	$this->endBody() 
	?>
  
  <script type="text/javascript">
$('#iteasyorderproduct-it_easy_product_id').change(function(){   
    var csrfToken = $('meta[name="csrf-token"]').attr("content"); 
    var getproductid = $(this).val();
    alert(getproductid); 
    $.ajax({
        url :    JS_BASE_URL + 'order/buyvariation',
        method : 'GET',
        data : {_csrf : csrfToken, 'setid' : getproductid},
        success : function(data){
             $('#iteasyorderproduct-it_easy_variation_id').html(data);
         }
    });
});
</script>
  
  
</body>
</html>
<?php $this->endPage();
