<?php

use backend\models\ItEasyOrder;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

/** @var yii\web\View $this */
/** @var backend\models\ItEasyOrderSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Courier Data Analysis Report';
$this->params['breadcrumbs'][] = $this->title;
  $courier_dipatch = []; $courier_delivery = []; $courier_rto = []; $courierwise_courier = [];
  $dispatch_count = 0;
  $delivered_count = 0;
  $rto_count = 0;

if(!empty($courierwiseReport)){
  foreach ($courierwiseReport as $key => $courier) {
     $dispatch_count += $courier['dispatched_order_count'];
     $delivered_count += $courier['delivered_order_count'];
     $rto_count += $courier['rto_order_count'];
     $courier_dipatch[] = intval($courier['dispatched_order_count']);
     $courier_delivery[] = intval($courier['delivered_order_count']);
     $courier_rto[] = intval($courier['rto_order_count']);
     $courierwise_courier[] = $courier['courier_name'];
 }
}else{
    $courier_dipatch = [0, 0,0, 0, 0];
    $courier_delivery = [0, 0,0, 0, 0];
    $courier_rto = [0, 0,0, 0, 0];
    $dispatch_count = 0;
    $delivered_count = 0;
    $rto_count = 0;
    $courierwise_courier = ['Xpressbees', 'Ecom Express', 'Delhivery', 'Shipdelight', 'Ecom Express AIR'];
}

$zone_dipatch = []; $zone_delivery = []; $zone_rto = []; $courierwise_zone = [];
$dispatch_zonecount = 0;
$delivered_zonecount = 0;
$rto_zonecount = 0;

if(!empty($courierzonewiseReport)){
  foreach ($courierzonewiseReport as $key => $zone) {
     $dispatch_zonecount += $zone['dispatched_order_count'];
     $delivered_zonecount += $zone['delivered_order_count'];
     $rto_zonecount += $zone['rto_order_count'];
     $zone_dipatch[] = intval($zone['dispatched_order_count']);
     $zone_delivery[] = intval($zone['delivered_order_count']);
     $zone_rto[] = intval($zone['rto_order_count']);
     $courierwise_zone[] = $zone['zone_name'];
  }
}else{
    $zone_dipatch = [0, 0,0, 0, 0];
    $zone_delivery = [0, 0,0, 0, 0];
    $zone_rto = [0, 0,0, 0, 0];
    $dispatch_zonecount = 0;
    $delivered_zonecount = 0;
    $rto_zonecount = 0;
    $courierwise_zone = ['Zone A', 'Zone B', 'Zone C', 'Zone D', 'Zone E'];
}
if(!empty($dispatch_count)){

$delivery_percentage = ROUND(($delivered_count / $dispatch_count ) * 100);

$rto_percentage = ROUND(($rto_count / $dispatch_count ) * 100);
}else{
    $delivery_percentage = '0';
    $rto_percentage = '0';
}
// echo "<pre>"; print_r($courier_dipatch); die;

if(isset(Yii::$app->user->identity->it_easy_platform)){
    $platform = explode(',', Yii::$app->user->identity->it_easy_platform);
    $search_array = [];
    foreach ($platform as $key => $value) {
        $search_array[$value] = $value;
    }
}

?>
<style type="text/css">

  .bg-gray-200{
    border-radius: 8px; 
  }
  .font-weight-bold{
      color: #2cac81;
      font-size: 18px;
      font-weight: bolder;
      font-family: cursive;
  }
  .mb-1{
    font-weight: 700;
    font-size: 12px;
    margin-top: 15px;
  }
  .card-order-total{
    border-radius: 0px !important;
    border: none !important;
  }
  textarea{
    border-radius: 10px !important;
    background-color: #ffffff !important;
    border: 2px solid #fdfdfd !important;
  }
  th{
    font-size: 16px !important;
    font-family: monospace;
    font-weight: bolder !important;
    text-align: center !important;
  }
</style>
<!-- container -->
<div class="container-fluid">

    <div class="row row-sm" style="margin-top: 40px;
    background: #edecec;
    padding-top: 20px;
    border-radius: 9px;">

        <div class="col-xl-12 col-md-12">
              <div class="col-md-12">
    <?php $formsearch = ActiveForm::begin(['action' => ['index'],'method' => 'get']); ?>
                
                    
                    <div class="col-md-2">
                        <?= $formsearch->field($searchModel, 'it_easy_marketer_id')->dropDownlist($arreyHelper_courier, ['prompt' => 'Search by Courier Name'])->label(false); ?>
                    </div>
                    
                    <div class="col-md-2">
                        <?= $formsearch->field($searchModel, 'it_easy_platform')->dropDownlist($search_array, ['prompt' => 'Search by platform'])->label(false); ?>
                    </div>

                    <div class="col-md-1">
                        <?= $formsearch->field($searchModel, 'it_easy_first_status')->dropDownlist([ 'COD' => 'COD', 'Prepaid' => 'Prepaid'], ['prompt' => 'Search by Order Type'])->label(false); ?>
                    </div>
                    
                    <div class="col-md-2">
                        <?= $formsearch->field($searchModel, 'date_type_filter')->dropDownList(['Date Added' => 'Date Added', 'Date Modified' => 'Date Modified', 'Date Assigned' => 'Date Assigned', 'Date Converted' => 'Date Converted', 'Date Dispatched' => 'Date Dispatched', 'Date Delivered' => 'Date Delivered'])->label(false); ?>
                    </div>
                <div class="col-md-2">
                <div class="form-group field-iteasyordersearch-date_from_date">
                  <?= DatePicker::widget([
                  'name' => 'ItEasyOrderSearch[date_from_date]', 
                  'value' => empty($searchModel->date_from_date) ? date('Y-m').'-01' : $searchModel->date_from_date,
                  'options' => ['placeholder' => 'From date', 'id' => 'iteasyordersearch-date_from_date'],
                  'pluginOptions' => [
                  'format' => 'yyyy-mm-dd',
                  'todayHighlight' => true,
                  'autoclose' => true,
                  'placeholder' => 'Search by From date'
                      ]
                  ]) ?>
                </div>
                </div>
                <div class="col-md-2">
                <div class="form-group field-iteasyordersearch-date_to_date">
                    <?= DatePicker::widget([
                    'name' => 'ItEasyOrderSearch[date_to_date]', 
                    'value' => empty($searchModel->date_to_date) ? date('Y-m-d') : $searchModel->date_to_date,
                    'options' => ['placeholder' => 'To date', 'id' => 'iteasyordersearch-date_to_date'],
                    'pluginOptions' => [
                    'format' => 'yyyy-mm-dd',
                    'todayHighlight' => true,
                    'autoclose' => true,
                        ]
                    ]) ?>
                </div>
                </div>
            
            <div class="col-md-1">
                <?= Html::submitButton('Search', ['class' => 'btn btn-secondary btn-block']) ?>
            </div>
      <?php ActiveForm::end(); ?>
              <br>
              <h4 style="float: right; color: #3e3e6e;font-family: ui-monospace;">by default This Month data</4>
            <br>
            </div>
             
        </div>
      </div>

    <!-- breadcrumb -->
    <div class="breadcrumb-header justify-content-between">
        <div class="my-auto">
            <div class="d-flex">
                <h4 class="content-title mb-0 my-auto"><?= Html::encode($this->title) ?></h4>
            </div>
        </div>
    </div>
    <!-- breadcrumb -->





    <div class="row row-sm" style="padding: 15px;">
      <div class="col-sm-12 col-lg-6 col-xl-3">
        <div class="card card-img-holder">
          <div class="card-body list-icons">
            <div class="clearfix">
              <div class="float-right  mt-2">
                <span class="text-primary ">
                  <i class="si si-basket-loaded tx-30"></i>
                </span>
              </div>
              <div class="float-left">
                <p class="card-text text-muted mb-1">Total</p>
                <h3><?= !empty($courierlivewiseReport['dispatched_order_count']) ? $courierlivewiseReport['dispatched_order_count'] : '0'; ?></h3>
              </div>
            </div>
            <div class="card-footer p-0">
              <p class="text-muted mb-0 pt-4"><i class="si si-arrow-up-circle text-success mr-1-20  mr-2" aria-hidden="true"></i>Dispatch Orders</p>
            </div>
          </div>
        </div>
      </div>
      <div class="col-sm-12 col-lg-6 col-xl-3">
        <div class="card card-img-holder">
          <div class="card-body list-icons">
            <div class="clearfix">
              <div class="float-right  mt-2">
                <span class="text-primary ">
                  <i class="si si-chart tx-30"></i>
                </span>
              </div>
              <div class="float-left">
                <p class="card-text text-muted mb-1">Live</p>
                <h3><?= !empty($courierlivewiseReport['in_transit_count']) ? $courierlivewiseReport['in_transit_count'] : '0'; ?></h3>
              </div>
            </div>
            <div class="card-footer p-0">
              <p class="text-muted mb-0 pt-4"><i class="si si-exclamation text-info mr-2"></i>IN-Transit Orders</p>
            </div>
          </div>
        </div>
      </div>
      <div class="col-sm-12 col-lg-6 col-xl-3">
        <div class="card card-img-holder">
          <div class="card-body list-icons">
            <div class="clearfix">
              <div class="float-right  mt-2">
                <span class="text-primary">
                  <i class="si si-chart tx-30"></i>
                </span>
              </div>
              <div class="float-left">
                <p class="card-text text-muted mb-1">NDR</p>
                <h3><?= !empty($courierlivewiseReport['ndr_order_count']) ? $courierlivewiseReport['ndr_order_count'] : '0'; ?></h3>
              </div>
            </div>
            <div class="card-footer p-0">
              <p class="text-muted mb-0 pt-4"><i class="si si-exclamation text-info mr-2"></i>NDR Orders</p>
            </div>
          </div>
        </div>
      </div>
      <div class="col-sm-12 col-lg-6 col-xl-3">
        <div class="card card-img-holder">
          <div class="card-body list-icons">
            <div class="clearfix">
              <div class="float-right  mt-2">
                <span class="text-primary">
                  <i class="si si-credit-card tx-30"></i>
                </span>
              </div>
              <div class="float-left">
                <p class="card-text text-muted mb-1">Complete</p>
                <h3><?= !empty($courierlivewiseReport['complete_order_count']) ? $courierlivewiseReport['complete_order_count'] : '0'; ?></h3>
              </div>
            </div>
            <div class="card-footer p-0">
              <p class="text-muted mb-0 pt-4"><i class="si si-check mr-1 text-primary mr-2"></i> Complete Orders</p>
            </div>
          </div>
        </div>
      </div>
    </div>  
    

    <!-- row opened -->
    
    <div class="row row-sm">
      <div class="col-md-12" style="padding: 15px;">
          <div class="col-md-7 col-lg-7 col-xl-7">
              <div class="card">
                  <div class="card-header bg-transparent pd-b-0 pd-t-20 bd-b-0">
                      <div class="d-flex justify-content-between">
                          <h4 class="card-title mb-0">Courier Wise Report</h4>
                          <i class="mdi mdi-dots-horizontal text-gray"></i>
                      </div>
                      <p class="tx-12 text-muted mb-0">Track your order from ship date to arrival.</p>
                  </div>
                  <div class="card-body">
                      <div class="total-revenue">
                          <div>
                            <h4><?= $dispatch_count; ?></h4>
                            <label><span class="bg-primary"></span>Dispatch</label>
                          </div>
                          <div>
                            <h4><?= $delivered_count; ?></h4>
                            <label><span class="bg-warning"></span>Delivered</label>
                          </div>
                          <div>
                            <h4><?= $rto_count; ?></h4>
                            <label><span class="bg-danger"></span>R T O</label>
                          </div>
                        </div>
                      <div id="bar" class="sales-bar mt-4"></div>
                  </div>
              </div>


              <div class="card">
                  <div class="card-header bg-transparent pd-b-0 pd-t-20 bd-b-0">
                      <div class="d-flex justify-content-between">
                          <h4 class="card-title mb-0">Zone Wise Report</h4>
                          <i class="mdi mdi-dots-horizontal text-gray"></i>
                      </div>
                      <p class="tx-12 text-muted mb-0">Track your order from ship date to arrival.</p>
                  </div>
                  <div class="card-body">
                      <div class="total-revenue">
                          <div>
                            <h4><?= $dispatch_zonecount; ?></h4>
                            <label><span class="bg-primary"></span>Dispatch</label>
                          </div>
                          <div>
                            <h4><?= $delivered_zonecount; ?></h4>
                            <label><span class="bg-warning"></span>Delivered</label>
                          </div>
                          <div>
                            <h4><?= $rto_zonecount; ?></h4>
                            <label><span class="bg-danger"></span>R T O</label>
                          </div>
                        </div>
                      <div id="bar2" class="sales-bar mt-4"></div>
                  </div>
              </div>

          </div>
          <div class="col-xl-5 col-md-5 col-lg-5">
            <div class="card">
                <div class="card-header pb-0">
                    <h3 class="card-title mb-2">Delivered Order Percentage</h3>
                    <p class="tx-12 mb-0 text-muted">Get Delivery Percentage on your Dispatch Count</p>
                </div>
                <div class="card-body sales-info ot-0 pb-0 pt-0">
                    <br>
                    <br>
                    <div id="chart" class="ht-150" style="margin-bottom: 40px !important;"></div>
                </div>
            </div>

            <div class="card">
                <div class="card-header pb-0">
                    <h3 class="card-title mb-2">RTO Order Percentage</h3>
                    <p class="tx-12 mb-0 text-muted">Get RTO Percentage on your Dispatch Count</p>
                </div>
                <div class="card-body sales-info ot-0 pb-0 pt-0">
                    <br>
                    <br>
                    <div id="chart2" class="ht-150" style="margin-bottom: 40px !important;"></div>
                </div>
            </div>
          </div>

          



        </div>

        <div class="col-md-12" style="padding: 15px;">
          <div class="col-md-12 col-lg-12 col-xl-12">
              <div class="card card-table-two">
                  <div class="d-flex justify-content-between">
                      <h4 class="card-title mb-1">Courier Wise Check Best State</h4>
                      <i class="mdi mdi-dots-horizontal text-gray"></i>
                  </div>
                  <span class="tx-12 tx-muted mb-3 ">Get best State on Delivered, RTO status.</span>
                  <div class="table-responsive country-table">
                      <table class="table table-striped table-bordered mb-0 text-sm-nowrap text-lg-nowrap text-xl-nowrap">
                          <thead>
                              <tr>
                                  <th class="wd-lg-15p">State Name</th>
                                  <th class="wd-lg-15p tx-right">Dispatch Order</th>
                                  <th class="wd-lg-15p tx-right">Delivered Order</th>
                                  <th class="wd-lg-55p tx-right">Courier Stats</th>
                              </tr>
                          </thead>
                          <tbody>

                          <?php if(!empty($state_id_name)){ 
                              foreach ($state_id_name as $key => $state){ 

                                  $get_courierwise = ItEasyOrder::getsStateArrayDistinctReport($state['state_id'],$Params); 

                                  // echo "<pre>"; print_r($get_courierwise); die;
                                  

                            ?>  
                              <tr>
                                  <th class="wd-lg-15p"><?=  $state['state_name']; ?></th>
                                  <th class="wd-lg-15p tx-right"><span class="font-weight-bold"><?=  $state['dispatched_order_count']; ?></span></th>
                                  <th class="wd-lg-15p tx-right"><span class="font-weight-bold" ><?=  $state['delivered_order_count']; ?></span></th>
                                  <th class="wd-lg-55p tx-right">
                                      
                                      <?php if(!empty($get_courierwise)){
                                        foreach($get_courierwise as $key => $courier_report){
                                        if(!empty($courier_report['dispatched_order_count'])){
                                          $di_percentage =  ROUND(($courier_report['delivered_order_count'] / $courier_report['dispatched_order_count'] ) * 100);
                                        }else{
                                            $di_percentage = '0';
                                        }
                                       ?>
                                       <span><?= $courier_report['courier_name']; ?></span>&nbsp;&nbsp;&nbsp;&nbsp;<span class="font-weight-bold" >Dispatch - <?= $courier_report['dispatched_order_count']; ?>&nbsp;&nbsp;&nbsp;&nbsp;Delivered - <?= $courier_report['delivered_order_count']; ?>&nbsp;&nbsp;&nbsp;&nbsp;<?= $di_percentage; ?> %</span><br>
                                      <?php } } ?>  
                                  </th>
                              </tr>
                          <?php } } ?>    
                          </tbody>
                      </table>
                  </div>
              </div>
          </div>

        </div>



        <div class="col-md-12" style="padding: 15px;">
          <div class="col-md-12 col-lg-12 col-xl-12">
              <div class="card card-table-two">
                  <div class="d-flex justify-content-between">
                      <h4 class="card-title mb-1">State Wise Courier Report</h4>
                      <i class="mdi mdi-dots-horizontal text-gray"></i>
                  </div>
                  <span class="tx-12 tx-muted mb-3 ">Get best State on Delivered, RTO status.</span>
                  <div class="table-responsive country-table">
                      <table class="table table-striped table-bordered mb-0 text-sm-nowrap text-lg-nowrap text-xl-nowrap">
                          <thead>
                              <tr>
                                  <th class="wd-lg-20p">State Name</th>
                                  <th class="wd-lg-20p tx-right">Confirm Order</th>
                                  <th class="wd-lg-20p tx-right">Dispatch Order</th>
                                  <th class="wd-lg-20p tx-right">Delivered Order</th>
                                  <th class="wd-lg-20p tx-right">RTO Order</th>
                              </tr>
                          </thead>
                          <tbody>

                          <?php if(!empty($courierstatewiseReport)){ 
                              foreach ($courierstatewiseReport as $key => $stateWise){  
                                  if(!empty($stateWise['confirm_count'])){
                                    $dipatch_percentage_2 =  ROUND(($stateWise['dispatched_order_count'] / $stateWise['confirm_count'] ) * 100);
                                  }else{
                                      $dipatch_percentage_2 = '0';
                                  }
                                  if(!empty($stateWise['dispatched_order_count'])){
                                  $delivery_percentage_3 =  ROUND(($stateWise['delivered_order_count'] / $stateWise['dispatched_order_count'] ) * 100);
                                  $rto_percentage_2 =  ROUND(($stateWise['rto_order_count'] / $stateWise['dispatched_order_count'] ) * 100);
                                  }else{
                                      $delivery_percentage_3 = '0';
                                      $rto_percentage_2 = '0';
                                  }

                            ?>  
                              <tr>
                                  <th class="wd-lg-20p"><?=  $stateWise['state_name']; ?></th>
                                  <th class="wd-lg-20p tx-right"><span class="font-weight-bold"><?=  $stateWise['confirm_count']; ?></span></th>
                                  <th class="wd-lg-20p tx-right"><span class="font-weight-bold" style="float: left;"><?=  $stateWise['dispatched_order_count']; ?></span><span class="font-weight-bold" style="float: right;"><?=  $dipatch_percentage_2; ?>%</span></th>
                                  <th class="wd-lg-20p tx-right"><span class="font-weight-bold" style="float: left;"><?=  $stateWise['delivered_order_count']; ?></span><span  class="font-weight-bold" style="float: right;"><?=  $delivery_percentage_3; ?>%</span></th>
                                  <th class="wd-lg-20p tx-right"><span class="font-weight-bold" style="float: left;"><?=  $stateWise['rto_order_count']; ?></span><span class="font-weight-bold" style="float: right;"><?=  $rto_percentage_2; ?>%</span></th>
                              </tr>
                          <?php } } ?>    
                          </tbody>
                      </table>
                  </div>
              </div>
          </div>

        </div>

    </div>
    





</div>




<?php
include(dirname(__FILE__) . "/../common/alljs.php");
// echo "<pre>"; print_r($courier_dipatch); die;
// echo json_encode($courier_dipatch); die;
?>


<script type="text/javascript">


/* Apexcharts (#bar) */

  var jQueryArray1 = <?php echo json_encode($courier_dipatch); ?>;
  var jQueryArray2 = <?php echo json_encode($courier_delivery); ?>;
  var jQueryArray3 = <?php echo json_encode($courier_rto); ?>;
  var jQueryArray4 = <?php echo json_encode($courierwise_courier); ?>;
  var optionsBar = {
    chart: {
    height: 249,
    type: 'bar',
    toolbar: {
       show: false,
    },
    fontFamily: 'Nunito, sans-serif',
    dropShadow: {
      enabled: true,
      top: 1,
      left: 1,
      blur: 2,
      opacity: 0.2,
    }
    },
   colors: ["#a9a5f0", '#73bd8e', '#f28d9d'],
   plotOptions: {
        bar: {
          dataLabels: {
          enabled: false
          },
          columnWidth: '42%',
          endingShape: 'rounded',
        }
      },
    dataLabels: {
      enabled: false
    },
    stroke: {
      show: true,
      width: 2,
      endingShape: 'rounded',
      colors: ['transparent'],
    },
    responsive: [{
      breakpoint: 50076,
      options: {
         stroke: {
        show: true,
        width: 1,
        endingShape: 'rounded',
        colors: ['transparent'],
      },
      },
      
      
    }],
     series: [{
      name: 'Dispatch Order',
      data: jQueryArray1
    }, {
      name: 'Delivered Order',
      data: jQueryArray2
    }, {
      name: 'RTO Order',
      data: jQueryArray3
    }],
    xaxis: {
      categories: jQueryArray4,
    },
    
    
//     series: [{
// 		  name: 'Impressions',
// 		  data: [2074, 3385, 10057, 56, 76, 35, 61, 98, 36 , 50, 48, 29, 57]
// 	  }, {
// 		  name: 'Turnover',
// 		  data: [46, 35, 101, 98, 44, 55, 57, 56, 55 ,34, 79, 46,76]
// 	  }, {
// 		  name: 'In progress',
// 		  data: [26, 35, 41, 78, 34, 65, 27, 46, 37, 65, 49, 23,0]
// 	  }],
// 	  xaxis: {
// 		  categories: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct'],
// 	  },
	  
    fill: {
      opacity: 1
    },
    legend: {
    show: false,
    floating: true,
    position: 'top',
    horizontalAlign: 'left',
    

    },
   
    tooltip: {
      y: {
        formatter: function (val) {
          return val
        }
      }
    }
  }
  new ApexCharts(document.querySelector('#bar'), optionsBar).render();
  
  /* Apexcharts (#bar) closed */



  /* Apexcharts (#bar2) */

  var zoneArray1 = <?php echo json_encode($zone_dipatch); ?>;
  var zoneArray2 = <?php echo json_encode($zone_delivery); ?>;
  var zoneArray3 = <?php echo json_encode($zone_rto); ?>;
  var zoneArray4 = <?php echo json_encode($courierwise_zone); ?>;
  var optionsBar2 = {
    chart: {
    height: 249,
    type: 'bar',
    toolbar: {
       show: false,
    },
    fontFamily: 'Nunito, sans-serif',
    dropShadow: {
      enabled: true,
      top: 1,
      left: 1,
      blur: 2,
      opacity: 0.2,
    }
    },
   colors: ["#a9a5f0", '#73bd8e', '#f28d9d'],
   plotOptions: {
        bar: {
          dataLabels: {
          enabled: false
          },
          columnWidth: '42%',
          endingShape: 'rounded',
        }
      },
    dataLabels: {
      enabled: false
    },
    stroke: {
      show: true,
      width: 2,
      endingShape: 'rounded',
      colors: ['transparent'],
    },
    responsive: [{
      breakpoint: 576,
      options: {
         stroke: {
        show: true,
        width: 1,
        endingShape: 'rounded',
        colors: ['transparent'],
      },
      },
      
      
    }],
     series: [{
      name: 'Dispatch Order',
      data: zoneArray1
    }, {
      name: 'Delivered Order',
      data: zoneArray2
    }, {
      name: 'RTO Order',
      data: zoneArray3
    }],
    xaxis: {
      categories: zoneArray4,
    },
    fill: {
      opacity: 1
    },
    legend: {
    show: false,
    floating: true,
    position: 'top',
    horizontalAlign: 'left',
    

    },
   
    tooltip: {
      y: {
        formatter: function (val) {
          return val
        }
      }
    }
  }
  new ApexCharts(document.querySelector('#bar2'), optionsBar2).render();
  
  /* Apexcharts (#bar2) closed */



  
/*--- Apex (#chart) ---*/
  var options = {
    chart: {
    height: 205,
    type: 'radialBar',
     offsetX: 0,
          offsetY: 0,
  },
  plotOptions: {
    radialBar: {
    startAngle: -135,
    endAngle: 135,
    size: 120,
    imageWidth: 50,
            imageHeight: 50,
        
     track: { 
     strokeWidth: "80%",  
     background: '#ecf0fa', 
    },
     dropShadow: {
                enabled: false,
                top: 0,
                left: 0,
         bottom: 0,
                blur: 3,
                opacity: 0.5
              },
    dataLabels: {
      name: {
      fontSize: '16px',
      color: undefined,
      offsetY: 30,
      },
      hollow: { 
       size: "60%"  
      },
      value: {
      offsetY: -10,
      fontSize: '22px',
      color: undefined,
      formatter: function (val) {
        return val + "%";
      }
      }
    }
    }
  },
  colors: ['#0db2de'],
  fill: {
    type: "gradient",
    gradient: {
    shade: "dark",
    type: "horizontal",
    shadeIntensity: .5,
    gradientToColors: ['#f07529'],
    inverseColors: !0,
    opacityFrom: 1,
    opacityTo: 1,
    stops: [0, 100]
   }
  },
  stroke: {
    dashArray: 4
  },
   series: [<?= $delivery_percentage; ?>],  
    labels: [""]
  };

  var chart = new ApexCharts(document.querySelector("#chart"), options);
  chart.render();
  /*--- Apex (#chart)closed ---*/


  /*--- Apex (#chart2) ---*/
  var options2 = {
    chart: {
    height: 205,
    type: 'radialBar',
     offsetX: 0,
          offsetY: 0,
  },
  plotOptions: {
    radialBar: {
    startAngle: -135,
    endAngle: 135,
    size: 120,
    imageWidth: 50,
            imageHeight: 50,
        
     track: { 
     strokeWidth: "80%",  
     background: '#ecf0fa', 
    },
     dropShadow: {
                enabled: false,
                top: 0,
                left: 0,
         bottom: 0,
                blur: 3,
                opacity: 0.5
              },
    dataLabels: {
      name: {
      fontSize: '16px',
      color: undefined,
      offsetY: 30,
      },
      hollow: { 
       size: "60%"  
      },
      value: {
      offsetY: -10,
      fontSize: '22px',
      color: undefined,
      formatter: function (val) {
        return val + "%";
      }
      }
    }
    }
  },
  colors: ['#f07529'],
  fill: {
    type: "gradient",
    gradient: {
    shade: "dark",
    type: "horizontal",
    shadeIntensity: .5,
    gradientToColors: ['#f07529'],
    inverseColors: !0,
    opacityFrom: 1,
    opacityTo: 1,
    stops: [0, 100]
   }
  },
  stroke: {
    dashArray: 4
  },
   series: [<?= $rto_percentage; ?>],  
    labels: [""]
  };

  var chart = new ApexCharts(document.querySelector("#chart2"), options2);
  chart.render();
  /*--- Apex (#chart)closed ---*/

</script>